/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.analytics.stream.cardinality;

import com.clearspring.analytics.hash.Lookup3Hash;
import com.clearspring.analytics.stream.cardinality.ICardinality;
import com.clearspring.analytics.stream.cardinality.LinearCounting;
import com.clearspring.analytics.stream.cardinality.LogLog;
import com.clearspring.analytics.util.IBuilder;
import java.io.Serializable;
import java.util.Arrays;

public class AdaptiveCounting
extends LogLog {
    protected int b_e;
    protected final double B_s = 0.051;

    public AdaptiveCounting(int k) {
        super(k);
        this.b_e = this.m;
    }

    public AdaptiveCounting(byte[] M) {
        super(M);
        for (byte b : M) {
            if (b != 0) continue;
            ++this.b_e;
        }
    }

    @Override
    public boolean offer(Object o) {
        byte r;
        boolean modified = false;
        long x = Lookup3Hash.lookup3ycs64(o.toString());
        int j = (int)(x >>> 64 - this.k);
        if (this.M[j] < (r = (byte)(Long.numberOfLeadingZeros(x << this.k | (long)(1 << this.k - 1)) + 1))) {
            this.Rsum += r - this.M[j];
            if (this.M[j] == 0) {
                --this.b_e;
            }
            this.M[j] = r;
            modified = true;
        }
        return modified;
    }

    @Override
    public long cardinality() {
        double B = (double)this.b_e / (double)this.m;
        if (B >= 0.051) {
            return Math.round((double)(-this.m) * Math.log(B));
        }
        return super.cardinality();
    }

    protected static byte rho(long x, int k) {
        return (byte)(Long.numberOfLeadingZeros(x << k | (long)(1 << k - 1)) + 1);
    }

    @Override
    public ICardinality merge(ICardinality ... estimators) throws LogLog.LogLogMergeException {
        LogLog res = (LogLog)super.merge(estimators);
        return new AdaptiveCounting(res.M);
    }

    public static AdaptiveCounting mergeEstimators(LogLog ... estimators) throws LogLog.LogLogMergeException {
        if (estimators == null || estimators.length == 0) {
            return null;
        }
        return (AdaptiveCounting)estimators[0].merge(Arrays.copyOfRange(estimators, 1, estimators.length));
    }

    public static class Builder
    implements IBuilder<ICardinality>,
    Serializable {
        private static final long serialVersionUID = 2205437102378081334L;
        protected final int k;

        public Builder() {
            this(16);
        }

        public Builder(int k) {
            this.k = k;
        }

        @Override
        public AdaptiveCounting build() {
            return new AdaptiveCounting(this.k);
        }

        @Override
        public int sizeof() {
            return 1 << this.k;
        }

        public static IBuilder<ICardinality> obyCount(long maxCardinality) {
            if (maxCardinality <= 0L) {
                throw new IllegalArgumentException("maxCardinality (" + maxCardinality + ") must be a positive integer");
            }
            if (maxCardinality < 4250000L) {
                return LinearCounting.Builder.onePercentError((int)maxCardinality);
            }
            return new Builder(16);
        }
    }
}

