/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.lab.jvm.attach;

import java.io.PrintStream;
import org.gridkit.lab.jvm.attach.LogStream;

public class SysLogger {
    public static final SysLogStream DEBUG = new SysLogStream(null);
    public static final SysLogStream INFO = new SysLogStream(null);
    public static final SysLogStream WARN = new SysLogStream(System.err);
    public static final SysLogStream ERROR = new SysLogStream(System.err);

    public static LogStream debug(String name) {
        return DEBUG;
    }

    public static LogStream info(String name) {
        return INFO;
    }

    public static LogStream warn(String name) {
        return WARN;
    }

    public static LogStream error(String name) {
        return ERROR;
    }

    public static class SysLogStream
    extends LogStream {
        private PrintStream target;

        public SysLogStream(PrintStream target) {
            this.target = target;
        }

        public void setTarget(PrintStream ps) {
            this.target = ps;
        }

        @Override
        public void log(String message) {
            if (this.target != null) {
                this.target.println(message);
            }
        }

        @Override
        public void log(String message, Throwable error) {
            if (this.target != null) {
                if (message.length() > 0) {
                    this.target.println(message);
                }
                error.printStackTrace(this.target);
            }
        }
    }
}

