/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IncompatibleWindowException;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.NonMergingWindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;

public class SlidingWindows
extends NonMergingWindowFn<Object, IntervalWindow> {
    private final @UnknownKeyFor @NonNull @Initialized Duration period;
    private final @UnknownKeyFor @NonNull @Initialized Duration size;
    private final @UnknownKeyFor @NonNull @Initialized Duration offset;

    public static @UnknownKeyFor @NonNull @Initialized SlidingWindows of(@UnknownKeyFor @NonNull @Initialized Duration size) {
        return new SlidingWindows(SlidingWindows.getDefaultPeriod(size), size, Duration.ZERO);
    }

    public @UnknownKeyFor @NonNull @Initialized SlidingWindows every(@UnknownKeyFor @NonNull @Initialized Duration period) {
        return new SlidingWindows(period, this.size, this.offset);
    }

    public @UnknownKeyFor @NonNull @Initialized SlidingWindows withOffset(@UnknownKeyFor @NonNull @Initialized Duration offset) {
        return new SlidingWindows(this.period, this.size, offset);
    }

    private SlidingWindows(@UnknownKeyFor @NonNull @Initialized Duration period, @UnknownKeyFor @NonNull @Initialized Duration size, @UnknownKeyFor @NonNull @Initialized Duration offset) {
        if (offset.isShorterThan((ReadableDuration)Duration.ZERO) || !offset.isShorterThan((ReadableDuration)period) || !size.isLongerThan((ReadableDuration)Duration.ZERO)) {
            throw new IllegalArgumentException("SlidingWindows WindowingStrategies must have 0 <= offset < period and 0 < size");
        }
        this.period = period;
        this.size = size;
        this.offset = offset;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized IntervalWindow> windowCoder() {
        return IntervalWindow.getCoder();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized IntervalWindow> assignWindows(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized WindowFn. @UnknownKeyFor @NonNull @Initialized AssignContext c) {
        return this.assignWindows(c.timestamp());
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized IntervalWindow> assignWindows(@UnknownKeyFor @NonNull @Initialized Instant timestamp) {
        long lastStart;
        ArrayList<IntervalWindow> windows = new ArrayList<IntervalWindow>((int)(this.size.getMillis() / this.period.getMillis()));
        for (long start = lastStart = this.lastStartFor(timestamp); start > timestamp.minus((ReadableDuration)this.size).getMillis(); start -= this.period.getMillis()) {
            windows.add(new IntervalWindow(new Instant(start), (ReadableDuration)this.size));
        }
        return windows;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized WindowMappingFn<@UnknownKeyFor @NonNull @Initialized IntervalWindow> getDefaultWindowMappingFn() {
        return new WindowMappingFn<IntervalWindow>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized IntervalWindow getSideInputWindow(@UnknownKeyFor @NonNull @Initialized BoundedWindow mainWindow) {
                if (mainWindow instanceof GlobalWindow) {
                    throw new IllegalArgumentException("Attempted to get side input window for GlobalWindow from non-global WindowFn");
                }
                long lastStart = SlidingWindows.this.lastStartFor(mainWindow.maxTimestamp().minus((ReadableDuration)SlidingWindows.this.size));
                return new IntervalWindow(new Instant(lastStart + SlidingWindows.this.period.getMillis()), (ReadableDuration)SlidingWindows.this.size);
            }
        };
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isCompatible(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> other) {
        return this.equals(other);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean assignsToOneWindow() {
        return !this.period.isShorterThan((ReadableDuration)this.size);
    }

    @Override
    public void verifyCompatibility(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> other) throws @UnknownKeyFor @NonNull @Initialized IncompatibleWindowException {
        if (!this.isCompatible(other)) {
            throw new IncompatibleWindowException(other, String.format("Only %s objects with the same size, period and offset are compatible.", SlidingWindows.class.getSimpleName()));
        }
    }

    @Override
    public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item("size", this.size).withLabel("Window Size")).add(DisplayData.item("period", this.period).withLabel("Window Period")).add(DisplayData.item("offset", this.offset).withLabel("Window Start Offset"));
    }

    private @UnknownKeyFor @NonNull @Initialized long lastStartFor(@UnknownKeyFor @NonNull @Initialized Instant timestamp) {
        return timestamp.getMillis() - timestamp.plus((ReadableDuration)this.period).minus((ReadableDuration)this.offset).getMillis() % this.period.getMillis();
    }

    static @UnknownKeyFor @NonNull @Initialized Duration getDefaultPeriod(@UnknownKeyFor @NonNull @Initialized Duration size) {
        if (size.isLongerThan((ReadableDuration)Duration.standardHours((long)1L))) {
            return Duration.standardHours((long)1L);
        }
        if (size.isLongerThan((ReadableDuration)Duration.standardMinutes((long)1L))) {
            return Duration.standardMinutes((long)1L);
        }
        if (size.isLongerThan((ReadableDuration)Duration.standardSeconds((long)1L))) {
            return Duration.standardSeconds((long)1L);
        }
        return Duration.millis((long)1L);
    }

    public @UnknownKeyFor @NonNull @Initialized Duration getPeriod() {
        return this.period;
    }

    public @UnknownKeyFor @NonNull @Initialized Duration getSize() {
        return this.size;
    }

    public @UnknownKeyFor @NonNull @Initialized Duration getOffset() {
        return this.offset;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object object) {
        if (!(object instanceof SlidingWindows)) {
            return false;
        }
        SlidingWindows other = (SlidingWindows)object;
        return this.getOffset().equals((Object)other.getOffset()) && this.getSize().equals((Object)other.getSize()) && this.getPeriod().equals((Object)other.getPeriod());
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.size, this.offset, this.period);
    }
}

