/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CoderProvider;
import org.apache.beam.sdk.coders.CoderProviderRegistrar;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializableCoder<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized Serializable>
extends CustomCoder<T> {
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> MISSING_EQUALS_METHOD = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SerializableCoder.class);
    private final @UnknownKeyFor @NonNull @Initialized Class<T> type;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private transient @Nullable @UnknownKeyFor @Initialized TypeDescriptor<T> typeDescriptor;

    public static <T extends Serializable> @UnknownKeyFor @NonNull @Initialized SerializableCoder<T> of(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> type) {
        Class<T> clazz = type.getRawType();
        return new SerializableCoder<T>(clazz, type);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return false;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object structuralValue(T value) {
        return value;
    }

    public static <T extends Serializable> @UnknownKeyFor @NonNull @Initialized SerializableCoder<T> of(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        SerializableCoder.checkEqualsMethodDefined(clazz);
        return new SerializableCoder<T>(clazz, TypeDescriptor.of(clazz));
    }

    private static <T extends Serializable> void checkEqualsMethodDefined(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        boolean warn = true;
        if (!clazz.isInterface()) {
            Method method;
            try {
                method = clazz.getMethod("equals", Object.class);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)String.format("Concrete class %s has no equals method", clazz));
            }
            warn = Object.class.equals(method.getDeclaringClass());
        }
        if (warn && MISSING_EQUALS_METHOD.add(clazz)) {
            LOG.warn("Can't verify serialized elements of type {} have well defined equals method. This may produce incorrect results on some {} implementations", (Object)clazz.getSimpleName(), (Object)PipelineRunner.class.getSimpleName());
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized CoderProvider getCoderProvider() {
        return new SerializableCoderProvider();
    }

    protected SerializableCoder(@UnknownKeyFor @NonNull @Initialized Class<T> type, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor) {
        this.type = type;
        this.typeDescriptor = typeDescriptor;
    }

    public @UnknownKeyFor @NonNull @Initialized Class<T> getRecordType() {
        return this.type;
    }

    @Override
    public void encode(T value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ObjectOutputStream oos = new ObjectOutputStream(outStream);
        oos.writeObject(value);
        oos.flush();
    }

    @Override
    public T decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        try {
            ObjectInputStream ois = new ObjectInputStream(inStream);
            return (T)((Serializable)this.type.cast(ois.readObject()));
        }
        catch (ClassNotFoundException e) {
            throw new CoderException("unable to deserialize record", e);
        }
    }

    @Override
    public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        throw new Coder.NonDeterministicException(this, "Java Serialization may be non-deterministic.");
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
        return other != null && this.getClass() == other.getClass() && this.type == ((SerializableCoder)other).type;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.type.hashCode();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> getEncodedTypeDescriptor() {
        if (this.typeDescriptor == null) {
            this.typeDescriptor = TypeDescriptor.of(this.type);
        }
        return this.typeDescriptor;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "SerializableCoder(" + this.type.getName() + ")";
    }

    static class SerializableCoderProvider
    extends CoderProvider {
        SerializableCoderProvider() {
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized Coder<T> coderFor(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> componentCoders) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
            if (Serializable.class.isAssignableFrom(typeDescriptor.getRawType())) {
                return SerializableCoder.of(typeDescriptor);
            }
            throw new CannotProvideCoderException("Cannot provide SerializableCoder because " + typeDescriptor + " does not implement Serializable");
        }
    }

    public static class SerializableCoderProviderRegistrar
    implements CoderProviderRegistrar {
        @Override
        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized CoderProvider> getCoderProviders() {
            return ImmutableList.of((Object)SerializableCoder.getCoderProvider());
        }
    }
}

