/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.www.HopServerPipelineStatus;
import org.apache.hop.www.HopServerWorkflowStatus;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HopServerStatus {
    public static final String XML_TAG = "serverstatus";
    private String statusDescription;
    private String errorDescription;
    private List<HopServerPipelineStatus> pipelineStatusList;
    private List<HopServerWorkflowStatus> workflowStatusList;
    private long memoryFree;
    private long memoryTotal;
    private int cpuCores;
    private long cpuProcessTime;
    private long uptime;
    private int threadCount;
    private double loadAvg;
    private String osName;
    private String osVersion;
    private String osArchitecture;

    public HopServerStatus() {
        this.pipelineStatusList = new ArrayList<HopServerPipelineStatus>();
        this.workflowStatusList = new ArrayList<HopServerWorkflowStatus>();
    }

    public HopServerStatus(String statusDescription) {
        this();
        this.statusDescription = statusDescription;
    }

    public HopServerStatus(String statusDescription, List<HopServerPipelineStatus> pipelineStatusList, List<HopServerWorkflowStatus> workflowStatusList) {
        this.statusDescription = statusDescription;
        this.pipelineStatusList = pipelineStatusList;
        this.workflowStatusList = workflowStatusList;
    }

    @JsonIgnore
    public String getXml() throws HopException {
        StringBuilder xml = new StringBuilder();
        xml.append("<serverstatus>").append(Const.CR);
        xml.append(XmlHandler.addTagValue((String)"statusdesc", (String)this.statusDescription));
        xml.append(XmlHandler.addTagValue((String)"memory_free", (long)this.memoryFree));
        xml.append(XmlHandler.addTagValue((String)"memory_total", (long)this.memoryTotal));
        xml.append(XmlHandler.addTagValue((String)"cpu_cores", (int)this.cpuCores));
        xml.append(XmlHandler.addTagValue((String)"cpu_process_time", (long)this.cpuProcessTime));
        xml.append(XmlHandler.addTagValue((String)"uptime", (long)this.uptime));
        xml.append(XmlHandler.addTagValue((String)"thread_count", (int)this.threadCount));
        xml.append(XmlHandler.addTagValue((String)"load_avg", (double)this.loadAvg));
        xml.append(XmlHandler.addTagValue((String)"os_name", (String)this.osName));
        xml.append(XmlHandler.addTagValue((String)"os_version", (String)this.osVersion));
        xml.append(XmlHandler.addTagValue((String)"os_arch", (String)this.osArchitecture));
        xml.append("  <pipeline_status_list>").append(Const.CR);
        for (HopServerPipelineStatus pipelineStatus : this.pipelineStatusList) {
            xml.append("    ").append(pipelineStatus.getXml()).append(Const.CR);
        }
        xml.append("  </pipeline_status_list>").append(Const.CR);
        xml.append("  <workflow_status_list>").append(Const.CR);
        for (HopServerWorkflowStatus workflowStatus : this.workflowStatusList) {
            xml.append("    ").append(workflowStatus.getXml()).append(Const.CR);
        }
        xml.append("  </workflow_status_list>").append(Const.CR);
        xml.append("</serverstatus>").append(Const.CR);
        return xml.toString();
    }

    public HopServerStatus(Node statusNode) throws HopException {
        this();
        int i;
        this.statusDescription = XmlHandler.getTagValue((Node)statusNode, (String)"statusdesc");
        this.memoryFree = Const.toLong((String)XmlHandler.getTagValue((Node)statusNode, (String)"memory_free"), (long)-1L);
        this.memoryTotal = Const.toLong((String)XmlHandler.getTagValue((Node)statusNode, (String)"memory_total"), (long)-1L);
        String cpuCoresStr = XmlHandler.getTagValue((Node)statusNode, (String)"cpu_cores");
        this.cpuCores = Const.toInt((String)cpuCoresStr, (int)-1);
        String cpuProcessTimeStr = XmlHandler.getTagValue((Node)statusNode, (String)"cpu_process_time");
        this.cpuProcessTime = Utils.isEmpty((CharSequence)cpuProcessTimeStr) ? 0L : Long.valueOf(cpuProcessTimeStr);
        this.uptime = Const.toLong((String)XmlHandler.getTagValue((Node)statusNode, (String)"uptime"), (long)-1L);
        this.threadCount = Const.toInt((String)XmlHandler.getTagValue((Node)statusNode, (String)"thread_count"), (int)-1);
        this.loadAvg = Const.toDouble((String)XmlHandler.getTagValue((Node)statusNode, (String)"load_avg"), (double)-1.0);
        this.osName = XmlHandler.getTagValue((Node)statusNode, (String)"os_name");
        this.osVersion = XmlHandler.getTagValue((Node)statusNode, (String)"os_version");
        this.osArchitecture = XmlHandler.getTagValue((Node)statusNode, (String)"os_arch");
        Node listPipelineNode = XmlHandler.getSubNode((Node)statusNode, (String)"pipeline_status_list");
        Node listWorkflowsNode = XmlHandler.getSubNode((Node)statusNode, (String)"workflow_status_list");
        int nrPipelines = XmlHandler.countNodes((Node)listPipelineNode, (String)"pipeline-status");
        int nrWorkflows = XmlHandler.countNodes((Node)listWorkflowsNode, (String)"workflow-status");
        for (i = 0; i < nrPipelines; ++i) {
            Node pipelineStatusNode = XmlHandler.getSubNodeByNr((Node)listPipelineNode, (String)"pipeline-status", (int)i);
            this.pipelineStatusList.add(new HopServerPipelineStatus(pipelineStatusNode));
        }
        for (i = 0; i < nrWorkflows; ++i) {
            Node jobStatusNode = XmlHandler.getSubNodeByNr((Node)listWorkflowsNode, (String)"workflow-status", (int)i);
            this.workflowStatusList.add(new HopServerWorkflowStatus(jobStatusNode));
        }
    }

    public static HopServerStatus fromXml(String xml) throws HopException {
        Document document = XmlHandler.loadXmlString((String)xml);
        return new HopServerStatus(XmlHandler.getSubNode((Node)document, (String)XML_TAG));
    }

    public HopServerPipelineStatus findPipelineStatus(String pipelineName, String id) {
        for (HopServerPipelineStatus pipelineStatus : this.pipelineStatusList) {
            if (!pipelineStatus.getPipelineName().equalsIgnoreCase(pipelineName) || !Utils.isEmpty((CharSequence)id) && !pipelineStatus.getId().equals(id)) continue;
            return pipelineStatus;
        }
        return null;
    }

    public HopServerWorkflowStatus findWorkflowStatus(String workflowName, String id) {
        for (HopServerWorkflowStatus workflowStatus : this.workflowStatusList) {
            if (!workflowStatus.getWorkflowName().equalsIgnoreCase(workflowName) || !Utils.isEmpty((CharSequence)id) && !workflowStatus.getId().equals(id)) continue;
            return workflowStatus;
        }
        return null;
    }

    @Generated
    public String getStatusDescription() {
        return this.statusDescription;
    }

    @Generated
    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    @Generated
    public String getErrorDescription() {
        return this.errorDescription;
    }

    @Generated
    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    @Generated
    public List<HopServerPipelineStatus> getPipelineStatusList() {
        return this.pipelineStatusList;
    }

    @Generated
    public void setPipelineStatusList(List<HopServerPipelineStatus> pipelineStatusList) {
        this.pipelineStatusList = pipelineStatusList;
    }

    @Generated
    public List<HopServerWorkflowStatus> getWorkflowStatusList() {
        return this.workflowStatusList;
    }

    @Generated
    public void setWorkflowStatusList(List<HopServerWorkflowStatus> workflowStatusList) {
        this.workflowStatusList = workflowStatusList;
    }

    @Generated
    public long getMemoryFree() {
        return this.memoryFree;
    }

    @Generated
    public void setMemoryFree(long memoryFree) {
        this.memoryFree = memoryFree;
    }

    @Generated
    public long getMemoryTotal() {
        return this.memoryTotal;
    }

    @Generated
    public void setMemoryTotal(long memoryTotal) {
        this.memoryTotal = memoryTotal;
    }

    @Generated
    public int getCpuCores() {
        return this.cpuCores;
    }

    @Generated
    public void setCpuCores(int cpuCores) {
        this.cpuCores = cpuCores;
    }

    @Generated
    public long getCpuProcessTime() {
        return this.cpuProcessTime;
    }

    @Generated
    public void setCpuProcessTime(long cpuProcessTime) {
        this.cpuProcessTime = cpuProcessTime;
    }

    @Generated
    public long getUptime() {
        return this.uptime;
    }

    @Generated
    public void setUptime(long uptime) {
        this.uptime = uptime;
    }

    @Generated
    public int getThreadCount() {
        return this.threadCount;
    }

    @Generated
    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    @Generated
    public double getLoadAvg() {
        return this.loadAvg;
    }

    @Generated
    public void setLoadAvg(double loadAvg) {
        this.loadAvg = loadAvg;
    }

    @Generated
    public String getOsName() {
        return this.osName;
    }

    @Generated
    public void setOsName(String osName) {
        this.osName = osName;
    }

    @Generated
    public String getOsVersion() {
        return this.osVersion;
    }

    @Generated
    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    @Generated
    public String getOsArchitecture() {
        return this.osArchitecture;
    }

    @Generated
    public void setOsArchitecture(String osArchitecture) {
        this.osArchitecture = osArchitecture;
    }
}

