/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.engine;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.engine.IEngineMetric;
import org.apache.hop.pipeline.performance.PerformanceSnapShot;

public class EngineMetrics {
    private Date startDate;
    private Date endDate;
    private List<IEngineComponent> components = new ArrayList<IEngineComponent>();
    private Map<IEngineComponent, Map<IEngineMetric, Long>> componentMetricsMap = new HashMap<IEngineComponent, Map<IEngineMetric, Long>>();
    private Map<IEngineComponent, String> componentStatusMap = new HashMap<IEngineComponent, String>();
    private Map<IEngineComponent, String> componentSpeedMap = new HashMap<IEngineComponent, String>();
    private Map<IEngineComponent, Boolean> componentRunningMap = new HashMap<IEngineComponent, Boolean>();
    private Map<IEngineComponent, List<PerformanceSnapShot>> componentPerformanceSnapshots = new HashMap<IEngineComponent, List<PerformanceSnapShot>>();

    public Set<IEngineMetric> getMetricsList() {
        HashSet<IEngineMetric> set = new HashSet<IEngineMetric>();
        for (Map<IEngineMetric, Long> metricsMap : this.componentMetricsMap.values()) {
            for (IEngineMetric metric : metricsMap.keySet()) {
                set.add(metric);
            }
        }
        return set;
    }

    public void addComponent(IEngineComponent component) {
        this.components.add(component);
    }

    public void setComponentMetric(IEngineComponent component, IEngineMetric metric, Long amount) {
        if (component == null || metric == null) {
            throw new RuntimeException("Please provide a component and a metric to set");
        }
        Map<IEngineMetric, Long> metricsMap = this.componentMetricsMap.get(component);
        if (metricsMap == null) {
            metricsMap = new HashMap<IEngineMetric, Long>();
            this.componentMetricsMap.put(component, metricsMap);
        }
        metricsMap.put(metric, amount);
    }

    public void setComponentStatus(IEngineComponent component, String status) {
        this.componentStatusMap.put(component, status);
    }

    public void setComponentSpeed(IEngineComponent component, String status) {
        this.componentSpeedMap.put(component, status);
    }

    public void setComponentRunning(IEngineComponent component, Boolean running) {
        this.componentRunningMap.put(component, running);
    }

    public Long getComponentMetric(IEngineComponent component, IEngineMetric metric) {
        if (component == null || metric == null) {
            throw new RuntimeException("Please provide a component and a name for the metric to retrieve");
        }
        Map<IEngineMetric, Long> metricsMap = this.componentMetricsMap.get(component);
        if (metricsMap == null) {
            return null;
        }
        return metricsMap.get(metric);
    }

    public void incrementComponentMetric(IEngineComponent component, IEngineMetric metric) {
        if (component == null || metric == null) {
            throw new RuntimeException("Please provide a component and a name for the metric to increment");
        }
        Long amount = this.getComponentMetric(component, metric);
        if (amount == null) {
            this.setComponentMetric(component, metric, 1L);
        } else {
            this.setComponentMetric(component, metric, amount + 1L);
        }
    }

    public Long removeComponentMetric(IEngineComponent component, IEngineMetric metric) {
        if (component == null || metric == null) {
            throw new RuntimeException("Please provide a component and a name for the metric to remove");
        }
        Map<IEngineMetric, Long> metricsMap = this.componentMetricsMap.get(component);
        if (metricsMap == null) {
            return null;
        }
        return metricsMap.remove(metric);
    }

    public void addCompomentPerformanceSnapShot(IEngineComponent component, PerformanceSnapShot snapShot) {
        if (component == null || snapShot == null) {
            throw new RuntimeException("Please provide a component and a snapshot to add");
        }
        List<PerformanceSnapShot> snapShots = this.componentPerformanceSnapshots.get(component);
        if (snapShots == null) {
            snapShots = new ArrayList<PerformanceSnapShot>();
            this.componentPerformanceSnapshots.put(component, snapShots);
        }
        snapShots.add(snapShot);
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Map<IEngineComponent, Map<IEngineMetric, Long>> getComponentMetricsMap() {
        return this.componentMetricsMap;
    }

    public void setComponentMetricsMap(Map<IEngineComponent, Map<IEngineMetric, Long>> componentMetricsMap) {
        this.componentMetricsMap = componentMetricsMap;
    }

    public Map<IEngineComponent, String> getComponentStatusMap() {
        return this.componentStatusMap;
    }

    public void setComponentStatusMap(Map<IEngineComponent, String> componentStatusMap) {
        this.componentStatusMap = componentStatusMap;
    }

    public Map<IEngineComponent, String> getComponentSpeedMap() {
        return this.componentSpeedMap;
    }

    public void setComponentSpeedMap(Map<IEngineComponent, String> componentSpeedMap) {
        this.componentSpeedMap = componentSpeedMap;
    }

    public Map<IEngineComponent, Boolean> getComponentRunningMap() {
        return this.componentRunningMap;
    }

    public void setComponentRunningMap(Map<IEngineComponent, Boolean> componentRunningMap) {
        this.componentRunningMap = componentRunningMap;
    }

    public List<IEngineComponent> getComponents() {
        return this.components;
    }

    public void setComponents(List<IEngineComponent> components) {
        this.components = components;
    }

    public Map<IEngineComponent, List<PerformanceSnapShot>> getComponentPerformanceSnapshots() {
        return this.componentPerformanceSnapshots;
    }

    public void setComponentPerformanceSnapshots(Map<IEngineComponent, List<PerformanceSnapShot>> componentPerformanceSnapshots) {
        this.componentPerformanceSnapshots = componentPerformanceSnapshots;
    }
}

