/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.debug;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Condition;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.pipeline.debug.IBreakPointListener;
import org.apache.hop.pipeline.debug.PipelineDebugMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

public class TransformDebugMeta {
    public static final String XML_TAG = "transform-debug-meta";
    private TransformMeta transformMeta;
    private int rowCount;
    private boolean readingFirstRows = true;
    private boolean pausingOnBreakPoint;
    private Condition condition;
    private List<IBreakPointListener> breakPointListers;
    private IRowMeta rowBufferMeta;
    private List<Object[]> rowBuffer = new ArrayList<Object[]>();
    private int numberOfHits = 0;

    public TransformDebugMeta() {
        this.breakPointListers = new ArrayList<IBreakPointListener>();
    }

    public TransformDebugMeta(TransformMeta transformMeta) {
        this();
        this.transformMeta = transformMeta;
    }

    public TransformMeta getTransformMeta() {
        return this.transformMeta;
    }

    public void setTransformMeta(TransformMeta transformMeta) {
        this.transformMeta = transformMeta;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public void addBreakPointListener(IBreakPointListener breakPointListener) {
        this.breakPointListers.add(breakPointListener);
    }

    public void removeBreakPointListener(IBreakPointListener breakPointListener) {
        this.breakPointListers.remove(breakPointListener);
    }

    public void fireBreakPointListeners(PipelineDebugMeta pipelineDebugMeta) {
        for (IBreakPointListener listener : this.breakPointListers) {
            listener.breakPointHit(pipelineDebugMeta, this, this.rowBufferMeta, this.rowBuffer);
        }
        ++this.numberOfHits;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public boolean isReadingFirstRows() {
        return this.readingFirstRows;
    }

    public void setReadingFirstRows(boolean readingFirstRows) {
        this.readingFirstRows = readingFirstRows;
    }

    public boolean isPausingOnBreakPoint() {
        return this.pausingOnBreakPoint;
    }

    public void setPausingOnBreakPoint(boolean pausingOnBreakPoint) {
        this.pausingOnBreakPoint = pausingOnBreakPoint;
    }

    public IRowMeta getRowBufferMeta() {
        return this.rowBufferMeta;
    }

    public void setRowBufferMeta(IRowMeta rowBufferMeta) {
        this.rowBufferMeta = rowBufferMeta;
    }

    public List<Object[]> getRowBuffer() {
        return this.rowBuffer;
    }

    public void setRowBuffer(List<Object[]> rowBuffer) {
        this.rowBuffer = rowBuffer;
    }

    public int getNumberOfHits() {
        return this.numberOfHits;
    }

    public void setNumberOfHits(int numberOfHits) {
        this.numberOfHits = numberOfHits;
    }
}

