/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.IPartitioner;
import org.apache.hop.pipeline.transform.TransformPartitioningMeta;

public abstract class BasePartitioner
implements IPartitioner {
    protected TransformPartitioningMeta meta;
    protected int nrPartitions = -1;
    protected String id;
    protected String description;

    @Override
    public IPartitioner clone() {
        IPartitioner partitioner = this.getInstance();
        partitioner.setId(this.id);
        partitioner.setDescription(this.description);
        partitioner.setMeta(this.meta);
        return partitioner;
    }

    public int getNrPartitions() {
        return this.nrPartitions;
    }

    public void setNrPartitions(int nrPartitions) {
        this.nrPartitions = nrPartitions;
    }

    public void init(IVariables variables, IRowMeta rowMeta) throws HopException {
        if (this.nrPartitions < 0) {
            this.nrPartitions = this.meta.getPartitionSchema().calculatePartitionIds(variables).size();
        }
    }

    public TransformPartitioningMeta getMeta() {
        return this.meta;
    }

    @Override
    public void setMeta(TransformPartitioningMeta meta) {
        this.meta = meta;
    }

    @Override
    public abstract IPartitioner getInstance();

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }
}

