/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.execution.caching;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.execution.Execution;
import org.apache.hop.execution.ExecutionData;
import org.apache.hop.execution.ExecutionState;
import org.apache.hop.execution.caching.EntrySummary;

public class CacheEntry {
    private String id;
    @JsonIgnore
    private String internalId;
    private String name;
    private Execution execution;
    private ExecutionState executionState;
    @JsonSerialize
    private Map<String, Execution> childExecutions = new HashMap<String, Execution>();
    @JsonSerialize
    private Map<String, ExecutionState> childExecutionStates = new HashMap<String, ExecutionState>();
    @JsonSerialize
    private Map<String, ExecutionData> childExecutionData = new HashMap<String, ExecutionData>();
    private EntrySummary summary = new EntrySummary();
    @JsonIgnore
    private Date lastWritten = new Date();
    @JsonIgnore
    private Date lastRead;
    @JsonIgnore
    private boolean dirty = true;

    public void writeToDisk(String rootFolder) throws HopException {
        String targetFilename = this.calculateFilename(rootFolder);
        String filename = this.calculateFilename(rootFolder) + ".new";
        try (FileOutputStream fos = new FileOutputStream(filename);){
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.writeValue((OutputStream)fos, (Object)this);
        }
        catch (Exception e) {
            throw new HopException("Error writing cache entry to file '" + this.calculateFilename(rootFolder) + "'", (Throwable)e);
        }
        try {
            FileObject targetFileObject = HopVfs.getFileObject((String)targetFilename);
            targetFileObject.delete();
            FileObject fileObject = HopVfs.getFileObject((String)filename);
            fileObject.moveTo(targetFileObject);
        }
        catch (Exception e) {
            throw new HopException("Error renaming execution information to file '" + targetFilename + "'", (Throwable)e);
        }
        this.dirty = false;
        this.lastWritten = new Date();
        this.lastRead = null;
    }

    public void deleteFromDisk(String rootFolder) throws HopException {
        String targetFilename = this.calculateFilename(rootFolder);
        try {
            FileObject fileObject = HopVfs.getFileObject((String)targetFilename);
            fileObject.delete();
        }
        catch (Exception e) {
            throw new HopException("Error deleting execution information file '" + targetFilename + "'", (Throwable)e);
        }
    }

    public String calculateFilename(String rootFolder) {
        return rootFolder + Const.FILE_SEPARATOR + this.id + ".json";
    }

    public void addChildExecution(Execution childExecution) {
        this.childExecutions.put(childExecution.getId(), childExecution);
        this.flagDirty();
    }

    public void addExecutionData(ExecutionData executionData) {
        this.childExecutionData.put(executionData.getOwnerId(), executionData);
        this.flagDirty();
    }

    public ExecutionData getExecutionData(String ownerId) {
        this.flagRead();
        return this.childExecutionData.get(ownerId);
    }

    private void flagDirty() {
        if (!this.dirty) {
            this.dirty = true;
            this.lastWritten = new Date();
        }
    }

    private void flagRead() {
        this.lastRead = new Date();
    }

    public Execution getChildExecution(String id) {
        this.flagRead();
        return this.childExecutions.get(id);
    }

    public void addChildExecutionState(ExecutionState executionState) {
        Object executionId = executionState.getId();
        if (StringUtils.isEmpty((String)executionId)) {
            executionId = executionState.getName() + "." + executionState.getCopyNr();
        }
        this.childExecutionStates.put((String)executionId, executionState);
        this.flagDirty();
    }

    public ExecutionState getChildExecutionState(String id) {
        this.flagRead();
        return this.childExecutionStates.get(id);
    }

    public boolean needsWriting(int persistenceDelay) {
        if (!this.dirty) {
            return false;
        }
        if (this.lastWritten == null) {
            return true;
        }
        return System.currentTimeMillis() - this.lastWritten.getTime() > (long)persistenceDelay;
    }

    public boolean isTooOld(int maxAge) {
        if (this.lastRead != null && System.currentTimeMillis() - this.lastRead.getTime() > (long)maxAge) {
            return true;
        }
        return this.lastWritten != null && System.currentTimeMillis() - this.lastWritten.getTime() > (long)maxAge;
    }

    public List<String> getChildIds() {
        return new ArrayList<String>(this.childExecutions.keySet());
    }

    public void calculateSummary() {
        this.summary.calculateSummary(this);
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @JsonIgnore
    @Generated
    public void setInternalId(String internalId) {
        this.internalId = internalId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setExecution(Execution execution) {
        this.execution = execution;
    }

    @Generated
    public void setExecutionState(ExecutionState executionState) {
        this.executionState = executionState;
    }

    @Generated
    public void setChildExecutions(Map<String, Execution> childExecutions) {
        this.childExecutions = childExecutions;
    }

    @Generated
    public void setChildExecutionStates(Map<String, ExecutionState> childExecutionStates) {
        this.childExecutionStates = childExecutionStates;
    }

    @Generated
    public void setChildExecutionData(Map<String, ExecutionData> childExecutionData) {
        this.childExecutionData = childExecutionData;
    }

    @Generated
    public void setSummary(EntrySummary summary) {
        this.summary = summary;
    }

    @JsonIgnore
    @Generated
    public void setLastWritten(Date lastWritten) {
        this.lastWritten = lastWritten;
    }

    @JsonIgnore
    @Generated
    public void setLastRead(Date lastRead) {
        this.lastRead = lastRead;
    }

    @JsonIgnore
    @Generated
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getInternalId() {
        return this.internalId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Execution getExecution() {
        return this.execution;
    }

    @Generated
    public ExecutionState getExecutionState() {
        return this.executionState;
    }

    @Generated
    public Map<String, Execution> getChildExecutions() {
        return this.childExecutions;
    }

    @Generated
    public Map<String, ExecutionState> getChildExecutionStates() {
        return this.childExecutionStates;
    }

    @Generated
    public Map<String, ExecutionData> getChildExecutionData() {
        return this.childExecutionData;
    }

    @Generated
    public EntrySummary getSummary() {
        return this.summary;
    }

    @Generated
    public Date getLastWritten() {
        return this.lastWritten;
    }

    @Generated
    public Date getLastRead() {
        return this.lastRead;
    }

    @Generated
    public boolean isDirty() {
        return this.dirty;
    }
}

