/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.util;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;

public class CurrentDirectoryResolver {
    public IVariables resolveCurrentDirectory(IVariables parentVariables, String filename) {
        Variables tmpSpace = new Variables();
        tmpSpace.setParentVariables(parentVariables);
        tmpSpace.initializeFrom(parentVariables);
        if (filename != null) {
            try {
                FileObject fileObject = HopVfs.getFileObject((String)filename);
                if (!fileObject.exists()) {
                    return tmpSpace;
                }
                FileName fileName = fileObject.getName();
                tmpSpace.setVariable("Internal.Workflow.Filename.Name", fileName.getBaseName());
                FileName fileDir = fileName.getParent();
                tmpSpace.setVariable("Internal.Pipeline.Filename.Directory", fileDir.getURI());
                tmpSpace.setVariable("Internal.Workflow.Filename.Folder", fileDir.getURI());
                tmpSpace.setVariable("Internal.Entry.Current.Folder", fileDir.getURI());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to figure out the current directory", e);
            }
        }
        return tmpSpace;
    }

    public IVariables resolveCurrentDirectory(IVariables parentVariables, TransformMeta transformMeta, String filename) {
        if (transformMeta != null && transformMeta.getParentPipelineMeta() != null) {
            filename = transformMeta.getParentPipelineMeta().getFilename();
        } else if (transformMeta != null && transformMeta.getParentPipelineMeta() != null && filename == null) {
            filename = transformMeta.getParentPipelineMeta().getFilename();
        }
        return this.resolveCurrentDirectory(parentVariables, filename);
    }

    public IVariables resolveCurrentDirectory(IVariables parentVariables, IWorkflowEngine<WorkflowMeta> workflow, String filename) {
        if (workflow != null && filename == null) {
            filename = workflow.getFilename();
        } else if (WorkflowMeta.class.isAssignableFrom(parentVariables.getClass())) {
            WorkflowMeta realParent = null;
            realParent = (WorkflowMeta)parentVariables;
            filename = realParent.getFilename();
        }
        return this.resolveCurrentDirectory(parentVariables, filename);
    }

    public String normalizeSlashes(String str) {
        if (StringUtils.isBlank((String)str)) {
            return str;
        }
        while (str.contains("\\")) {
            str = str.replace("\\", "/");
        }
        while (str.contains("//")) {
            str = str.replace("//", "/");
        }
        return str;
    }
}

