/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.listeners.impl;

import com.google.common.base.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.listeners.ICurrentDirectoryChangedListener;
import org.apache.hop.core.variables.Variables;

public class EntryCurrentDirectoryChangedListener
implements ICurrentDirectoryChangedListener {
    private IPathReference[] references;

    public EntryCurrentDirectoryChangedListener(IPathReference ... refs) {
        this.references = refs;
    }

    public EntryCurrentDirectoryChangedListener(final Supplier<String> pathGetter, final Consumer<String> pathSetter) {
        this(new IPathReference(){

            @Override
            public String getPath() {
                return (String)pathGetter.get();
            }

            @Override
            public void setPath(String path) {
                pathSetter.accept(path);
            }
        });
    }

    @Override
    public void directoryChanged(Object origin, String oldCurrentDir, String newCurrentDir) {
        for (IPathReference ref : this.references) {
            String path = ref.getPath();
            if (!StringUtils.contains((String)path, (String)"Internal.Entry.Current.Folder") || Objects.equal((Object)oldCurrentDir, (Object)newCurrentDir)) continue;
            path = this.reapplyCurrentDir(oldCurrentDir, newCurrentDir, path);
            ref.setPath(path);
        }
    }

    private String reapplyCurrentDir(String oldCurrentDir, String newCurrentDir, String path) {
        Variables vars = new Variables();
        vars.setVariable("Internal.Entry.Current.Folder", oldCurrentDir);
        String newPath = vars.resolve(path);
        return EntryCurrentDirectoryChangedListener.getPath(newCurrentDir, newPath);
    }

    private static String getPath(String parentPath, String path) {
        if (!parentPath.equals("/") && path.startsWith(parentPath)) {
            path = path.replace(parentPath, "${Internal.Entry.Current.Folder}");
        }
        return path;
    }

    public static interface IPathReference {
        public String getPath();

        public void setPath(String var1);
    }
}

