/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mongo.metadata;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.mongo.metadata.MongoDbConnection;
import org.apache.hop.mongo.wrapper.MongoClientWrapper;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.ShowMessageDialog;
import org.apache.hop.ui.core.gui.GuiCompositeWidgets;
import org.apache.hop.ui.core.gui.GuiCompositeWidgetsAdapter;
import org.apache.hop.ui.core.gui.IGuiPluginCompositeWidgetsListener;
import org.apache.hop.ui.core.metadata.IMetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class MongoDbConnectionEditor
extends MetadataEditor<MongoDbConnection>
implements IMetadataEditor<MongoDbConnection> {
    private static final Class<?> PKG = MongoDbConnectionEditor.class;
    public static final String PARENT_WIDGET_ID = "MongoDbConnectionEditor.Widgets.ParentId";
    private Composite parent;
    private Text wName;
    private GuiCompositeWidgets widgets;

    public MongoDbConnectionEditor(HopGui hopGui, MetadataManager<MongoDbConnection> manager, MongoDbConnection metadata) {
        super(hopGui, manager, (IHopMetadata)metadata);
    }

    public void createControl(Composite parent) {
        this.parent = parent;
        PropsUi props = PropsUi.getInstance();
        int margin = PropsUi.getMargin();
        int middle = props.getMiddlePct();
        Label wlName = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlName);
        wlName.setText("MongoDB Connection name");
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, margin * 2);
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, 0);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(parent, 18436);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        fdName.left = new FormAttachment(middle, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        this.widgets = new GuiCompositeWidgets(this.manager.getVariables());
        this.widgets.createCompositeWidgets((Object)this.getMetadata(), null, parent, PARENT_WIDGET_ID, (Control)this.wName);
        this.setWidgetsContent();
        this.wName.addListener(24, e -> this.setChanged());
        this.widgets.setWidgetsListener((IGuiPluginCompositeWidgetsListener)new GuiCompositeWidgetsAdapter(){

            public void widgetModified(GuiCompositeWidgets compositeWidgets, Control changedWidget, String widgetId) {
                MongoDbConnectionEditor.this.setChanged();
            }
        });
    }

    public void setWidgetsContent() {
        MongoDbConnection meta = (MongoDbConnection)this.getMetadata();
        this.wName.setText(Const.NVL((String)meta.getName(), (String)""));
        this.widgets.setWidgetsContents((Object)meta, this.parent, PARENT_WIDGET_ID);
    }

    public void getWidgetsContent(MongoDbConnection meta) {
        meta.setName(this.wName.getText());
        this.widgets.getWidgetsContents((Object)meta, PARENT_WIDGET_ID);
    }

    public Button[] createButtonsForButtonBar(Composite parent) {
        PropsUi props = PropsUi.getInstance();
        Button wbGetDbs = new Button(parent, 0x1000008);
        PropsUi.setLook((Widget)wbGetDbs);
        wbGetDbs.setText("Get databases");
        wbGetDbs.addListener(13, e -> this.getDbNames());
        Button wbTest = new Button(parent, 0x1000008);
        PropsUi.setLook((Widget)wbTest);
        wbTest.setText("Test");
        wbTest.addListener(13, e -> this.test());
        return new Button[]{wbTest, wbGetDbs};
    }

    public void test() {
        try {
            MongoDbConnection meta = new MongoDbConnection();
            this.getWidgetsContent(meta);
            meta.test(this.manager.getVariables(), LogChannel.UI);
            MessageBox box = new MessageBox(this.parent.getShell(), 34);
            box.setText("Success!");
            box.setMessage("Connected successfully!");
            box.open();
        }
        catch (Exception e) {
            new ErrorDialog(this.parent.getShell(), "Error", "We couldn't connect using this information", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDbNames() {
        ComboVar wDbName = (ComboVar)this.widgets.getWidgetsMap().get("10200-database-name");
        IVariables variables = this.manager.getVariables();
        ILogChannel log = LogChannel.UI;
        String current = wDbName.getText();
        wDbName.removeAll();
        MongoDbConnection meta = new MongoDbConnection();
        this.getWidgetsContent(meta);
        String hostname = variables.resolve(meta.getHostname());
        if (!StringUtils.isEmpty((String)hostname)) {
            try {
                List<String> dbNames;
                MongoClientWrapper wrapper = meta.createWrapper(variables, log);
                try {
                    dbNames = wrapper.getDatabaseNames();
                }
                finally {
                    wrapper.dispose();
                }
                for (String s : dbNames) {
                    wDbName.add(s);
                }
            }
            catch (Exception e) {
                log.logError("Error connecting to MongoDB connection " + this.getName(), (Throwable)e);
                new ErrorDialog(this.parent.getShell(), "Error", "Error connecting to MongoDB connection " + this.getName(), e);
            }
        } else {
            ShowMessageDialog smd = new ShowMessageDialog(this.parent.getShell(), 40, "Warning", "Please provide a hostname to connect to");
            smd.open();
        }
        if (!StringUtils.isEmpty((String)current)) {
            wDbName.setText(current);
        }
    }
}

