/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalMap;
import java.io.Serializable;
import java.util.Map;

public class TagQueueRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String queueUrl;
    private SdkInternalMap<String, String> tags;

    public TagQueueRequest() {
    }

    public TagQueueRequest(String queueUrl, Map<String, String> tags) {
        this.setQueueUrl(queueUrl);
        this.setTags(tags);
    }

    public void setQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }

    public TagQueueRequest withQueueUrl(String queueUrl) {
        this.setQueueUrl(queueUrl);
        return this;
    }

    public Map<String, String> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalMap();
        }
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags == null ? null : new SdkInternalMap(tags);
    }

    public TagQueueRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public TagQueueRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new SdkInternalMap();
        }
        if (this.tags.containsKey((Object)key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put((Object)key, (Object)value);
        return this;
    }

    public TagQueueRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQueueUrl() != null) {
            sb.append("QueueUrl: ").append(this.getQueueUrl()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagQueueRequest)) {
            return false;
        }
        TagQueueRequest other = (TagQueueRequest)obj;
        if (other.getQueueUrl() == null ^ this.getQueueUrl() == null) {
            return false;
        }
        if (other.getQueueUrl() != null && !other.getQueueUrl().equals(this.getQueueUrl())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQueueUrl() == null ? 0 : this.getQueueUrl().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public TagQueueRequest clone() {
        return (TagQueueRequest)super.clone();
    }
}

