/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.secretmanager.v1beta2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SecretVersionName
implements ResourceName {
    private static final PathTemplate PROJECT_SECRET_SECRET_VERSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/secrets/{secret}/versions/{secret_version}");
    private static final PathTemplate PROJECT_LOCATION_SECRET_SECRET_VERSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/secrets/{secret}/versions/{secret_version}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String secret;
    private final String secretVersion;
    private final String location;

    @Deprecated
    protected SecretVersionName() {
        this.project = null;
        this.secret = null;
        this.secretVersion = null;
        this.location = null;
    }

    private SecretVersionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.secret = (String)Preconditions.checkNotNull((Object)builder.getSecret());
        this.secretVersion = (String)Preconditions.checkNotNull((Object)builder.getSecretVersion());
        this.location = null;
        this.pathTemplate = PROJECT_SECRET_SECRET_VERSION;
    }

    private SecretVersionName(ProjectLocationSecretSecretVersionBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.secret = (String)Preconditions.checkNotNull((Object)builder.getSecret());
        this.secretVersion = (String)Preconditions.checkNotNull((Object)builder.getSecretVersion());
        this.pathTemplate = PROJECT_LOCATION_SECRET_SECRET_VERSION;
    }

    public String getProject() {
        return this.project;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getSecretVersion() {
        return this.secretVersion;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectSecretSecretVersionBuilder() {
        return new Builder();
    }

    public static ProjectLocationSecretSecretVersionBuilder newProjectLocationSecretSecretVersionBuilder() {
        return new ProjectLocationSecretSecretVersionBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SecretVersionName of(String project, String secret, String secretVersion) {
        return SecretVersionName.newBuilder().setProject(project).setSecret(secret).setSecretVersion(secretVersion).build();
    }

    public static SecretVersionName ofProjectSecretSecretVersionName(String project, String secret, String secretVersion) {
        return SecretVersionName.newBuilder().setProject(project).setSecret(secret).setSecretVersion(secretVersion).build();
    }

    public static SecretVersionName ofProjectLocationSecretSecretVersionName(String project, String location, String secret, String secretVersion) {
        return SecretVersionName.newProjectLocationSecretSecretVersionBuilder().setProject(project).setLocation(location).setSecret(secret).setSecretVersion(secretVersion).build();
    }

    public static String format(String project, String secret, String secretVersion) {
        return SecretVersionName.newBuilder().setProject(project).setSecret(secret).setSecretVersion(secretVersion).build().toString();
    }

    public static String formatProjectSecretSecretVersionName(String project, String secret, String secretVersion) {
        return SecretVersionName.newBuilder().setProject(project).setSecret(secret).setSecretVersion(secretVersion).build().toString();
    }

    public static String formatProjectLocationSecretSecretVersionName(String project, String location, String secret, String secretVersion) {
        return SecretVersionName.newProjectLocationSecretSecretVersionBuilder().setProject(project).setLocation(location).setSecret(secret).setSecretVersion(secretVersion).build().toString();
    }

    public static SecretVersionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_SECRET_SECRET_VERSION.matches(formattedString)) {
            Map matchMap = PROJECT_SECRET_SECRET_VERSION.match(formattedString);
            return SecretVersionName.ofProjectSecretSecretVersionName((String)matchMap.get("project"), (String)matchMap.get("secret"), (String)matchMap.get("secret_version"));
        }
        if (PROJECT_LOCATION_SECRET_SECRET_VERSION.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_SECRET_SECRET_VERSION.match(formattedString);
            return SecretVersionName.ofProjectLocationSecretSecretVersionName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("secret"), (String)matchMap.get("secret_version"));
        }
        throw new ValidationException("SecretVersionName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<SecretVersionName> parseList(List<String> formattedStrings) {
        ArrayList<SecretVersionName> list = new ArrayList<SecretVersionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SecretVersionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SecretVersionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SecretVersionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_SECRET_SECRET_VERSION.matches(formattedString) || PROJECT_LOCATION_SECRET_SECRET_VERSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SecretVersionName secretVersionName = this;
            synchronized (secretVersionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.secret != null) {
                        fieldMapBuilder.put((Object)"secret", (Object)this.secret);
                    }
                    if (this.secretVersion != null) {
                        fieldMapBuilder.put((Object)"secret_version", (Object)this.secretVersion);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SecretVersionName that = (SecretVersionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.secret, that.secret) && Objects.equals(this.secretVersion, that.secretVersion) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.secret);
        h *= 1000003;
        h ^= Objects.hashCode(this.secretVersion);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    public static class ProjectLocationSecretSecretVersionBuilder {
        private String project;
        private String location;
        private String secret;
        private String secretVersion;

        protected ProjectLocationSecretSecretVersionBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSecret() {
            return this.secret;
        }

        public String getSecretVersion() {
            return this.secretVersion;
        }

        public ProjectLocationSecretSecretVersionBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationSecretSecretVersionBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationSecretSecretVersionBuilder setSecret(String secret) {
            this.secret = secret;
            return this;
        }

        public ProjectLocationSecretSecretVersionBuilder setSecretVersion(String secretVersion) {
            this.secretVersion = secretVersion;
            return this;
        }

        public SecretVersionName build() {
            return new SecretVersionName(this);
        }
    }

    public static class Builder {
        private String project;
        private String secret;
        private String secretVersion;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getSecret() {
            return this.secret;
        }

        public String getSecretVersion() {
            return this.secretVersion;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setSecret(String secret) {
            this.secret = secret;
            return this;
        }

        public Builder setSecretVersion(String secretVersion) {
            this.secretVersion = secretVersion;
            return this;
        }

        private Builder(SecretVersionName secretVersionName) {
            Preconditions.checkArgument((boolean)Objects.equals(secretVersionName.pathTemplate, PROJECT_SECRET_SECRET_VERSION), (Object)"toBuilder is only supported when SecretVersionName has the pattern of projects/{project}/secrets/{secret}/versions/{secret_version}");
            this.project = secretVersionName.project;
            this.secret = secretVersionName.secret;
            this.secretVersion = secretVersionName.secretVersion;
        }

        public SecretVersionName build() {
            return new SecretVersionName(this);
        }
    }
}

