/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.testing;

import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableConstraints;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class TableContainer {
    @UnknownKeyFor @NonNull @Initialized Table table;
    @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> primaryKeyColumns = null;
    @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> primaryKeyColumnIndices = null;
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object>, @UnknownKeyFor @NonNull @Initialized Long> lastSequenceNumber = Maps.newHashMap();
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableRow> rows;
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object>, @UnknownKeyFor @NonNull @Initialized TableRow> keyedRows;
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> ids;
    @UnknownKeyFor @NonNull @Initialized Long sizeBytes;

    TableContainer(@UnknownKeyFor @NonNull @Initialized Table table) {
        this.table = table;
        this.rows = new ArrayList<TableRow>();
        this.keyedRows = Maps.newHashMap();
        this.ids = new ArrayList<String>();
        this.sizeBytes = 0L;
        List<String> pkColumns = TableContainer.primaryKeyColumns(table);
        this.primaryKeyColumns = pkColumns;
        this.primaryKeyColumnIndices = TableContainer.primaryColumnFieldIndices(pkColumns, table);
    }

    static @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> primaryKeyColumns(@UnknownKeyFor @NonNull @Initialized Table table) {
        return Optional.ofNullable(table.getTableConstraints()).flatMap(constraints -> Optional.ofNullable(constraints.getPrimaryKey())).map(TableConstraints.PrimaryKey::getColumns).orElse(null);
    }

    static @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> primaryColumnFieldIndices(@Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> primaryKeyColumns, @UnknownKeyFor @NonNull @Initialized Table table) {
        if (primaryKeyColumns == null) {
            return null;
        }
        Map<String, Integer> indices = IntStream.range(0, table.getSchema().getFields().size()).boxed().collect(Collectors.toMap(i -> ((TableFieldSchema)table.getSchema().getFields().get((int)i)).getName(), i -> i));
        ArrayList primaryKeyColumnIndices = Lists.newArrayList();
        for (String columnName : primaryKeyColumns) {
            primaryKeyColumnIndices.add((Integer)Preconditions.checkStateNotNull((Object)indices.get(columnName)));
        }
        return primaryKeyColumnIndices;
    }

    void setPrimaryKeyColumns(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> primaryKeyColumns) {
        this.primaryKeyColumns = primaryKeyColumns;
        this.primaryKeyColumnIndices = TableContainer.primaryColumnFieldIndices(primaryKeyColumns, this.table);
    }

    @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized Object> getPrimaryKey(@UnknownKeyFor @NonNull @Initialized TableRow tableRow) {
        if (this.primaryKeyColumns == null) {
            return null;
        }
        @Nullable Object fValue = tableRow.get((Object)"f");
        if (fValue instanceof List) {
            List cellValues = ((List)fValue).stream().map(cell -> Preconditions.checkStateNotNull(cell.get("v"))).collect(Collectors.toList());
            return ((List)Preconditions.checkStateNotNull(this.primaryKeyColumnIndices)).stream().map(cellValues::get).collect(Collectors.toList());
        }
        return this.primaryKeyColumns.stream().map(arg_0 -> ((TableRow)tableRow).get(arg_0)).collect(Collectors.toList());
    }

    @UnknownKeyFor @NonNull @Initialized long addRow(@UnknownKeyFor @NonNull @Initialized TableRow row, @UnknownKeyFor @NonNull @Initialized String id) {
        List<Object> primaryKey = this.getPrimaryKey(row);
        if (primaryKey != null && !primaryKey.isEmpty()) {
            if (this.keyedRows.putIfAbsent(primaryKey, row) != null) {
                throw new RuntimeException("Primary key validation error! Multiple inserts with the same primary key.");
            }
        } else {
            this.rows.add(row);
            if (id != null) {
                this.ids.add(id);
            }
        }
        long tableSize = this.table.getNumBytes() == null ? 0L : this.table.getNumBytes();
        try {
            long rowSize = TableRowJsonCoder.of().getEncodedElementByteSize(row);
            this.table.setNumBytes(Long.valueOf(tableSize + rowSize));
            return rowSize;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to convert the row to JSON", ex);
        }
    }

    void upsertRow(@UnknownKeyFor @NonNull @Initialized TableRow row, @UnknownKeyFor @NonNull @Initialized long sequenceNumber) {
        List<Object> primaryKey = this.getPrimaryKey(row);
        if (primaryKey == null) {
            throw new RuntimeException("Upserts only allowed when using primary keys");
        }
        long lastSequenceNumberForKey = this.lastSequenceNumber.getOrDefault(primaryKey, Long.MIN_VALUE);
        if (sequenceNumber <= lastSequenceNumberForKey) {
            return;
        }
        TableRow oldValue = this.keyedRows.put(primaryKey, row);
        try {
            long tableSize;
            long l = tableSize = this.table.getNumBytes() == null ? 0L : this.table.getNumBytes();
            if (oldValue != null) {
                tableSize -= TableRowJsonCoder.of().getEncodedElementByteSize(oldValue);
            }
            this.table.setNumBytes(Long.valueOf(tableSize += TableRowJsonCoder.of().getEncodedElementByteSize(row)));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert the row to JSON", e);
        }
        this.lastSequenceNumber.put(primaryKey, sequenceNumber);
    }

    void deleteRow(@UnknownKeyFor @NonNull @Initialized TableRow row, @UnknownKeyFor @NonNull @Initialized long sequenceNumber) {
        List<Object> primaryKey = this.getPrimaryKey(row);
        if (primaryKey == null) {
            throw new RuntimeException("Upserts only allowed when using primary keys");
        }
        long lastSequenceNumberForKey = this.lastSequenceNumber.getOrDefault(primaryKey, -1L);
        if (sequenceNumber <= lastSequenceNumberForKey) {
            return;
        }
        TableRow oldValue = this.keyedRows.remove(primaryKey);
        try {
            if (oldValue != null) {
                long tableSize = this.table.getNumBytes() == null ? 0L : this.table.getNumBytes();
                this.table.setNumBytes(Long.valueOf(tableSize - TableRowJsonCoder.of().getEncodedElementByteSize(row)));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert the row to JSON", e);
        }
        this.lastSequenceNumber.put(primaryKey, sequenceNumber);
    }

    @UnknownKeyFor @NonNull @Initialized Table getTable() {
        return this.table;
    }

    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableRow> getRows() {
        if (this.primaryKeyColumns != null) {
            return Lists.newArrayList(this.keyedRows.values());
        }
        return this.rows;
    }

    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getIds() {
        return this.ids;
    }
}

