/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class TimestampUtils {
    private static final @UnknownKeyFor @NonNull @Initialized BigDecimal MIN_SECONDS = BigDecimal.valueOf(Timestamp.MIN_VALUE.getSeconds());
    private static final @UnknownKeyFor @NonNull @Initialized int NANOS_PER_SECOND = (int)TimeUnit.SECONDS.toNanos(1L);

    public static @UnknownKeyFor @NonNull @Initialized BigDecimal toNanos(@UnknownKeyFor @NonNull @Initialized Timestamp timestamp) {
        BigDecimal secondsAsNanos = BigDecimal.valueOf(timestamp.getSeconds()).subtract(MIN_SECONDS).scaleByPowerOfTen(9);
        BigDecimal nanos = BigDecimal.valueOf(timestamp.getNanos());
        return secondsAsNanos.add(nanos);
    }

    public static @UnknownKeyFor @NonNull @Initialized Timestamp toTimestamp(@UnknownKeyFor @NonNull @Initialized BigDecimal bigDecimal) {
        BigDecimal nanos = bigDecimal.remainder(BigDecimal.ONE.scaleByPowerOfTen(9));
        BigDecimal seconds = bigDecimal.subtract(nanos).scaleByPowerOfTen(-9).add(MIN_SECONDS);
        return Timestamp.ofTimeSecondsAndNanos((long)seconds.longValue(), (int)nanos.intValue());
    }

    public static @UnknownKeyFor @NonNull @Initialized Timestamp next(@UnknownKeyFor @NonNull @Initialized Timestamp timestamp) {
        if (timestamp.equals((Object)Timestamp.MAX_VALUE)) {
            return timestamp;
        }
        int nanos = timestamp.getNanos();
        long seconds = timestamp.getSeconds();
        if (nanos + 1 >= NANOS_PER_SECOND) {
            return Timestamp.ofTimeSecondsAndNanos((long)(seconds + 1L), (int)0);
        }
        return Timestamp.ofTimeSecondsAndNanos((long)seconds, (int)(nanos + 1));
    }

    public static @UnknownKeyFor @NonNull @Initialized Timestamp previous(@UnknownKeyFor @NonNull @Initialized Timestamp timestamp) {
        if (timestamp.equals((Object)Timestamp.MIN_VALUE)) {
            return timestamp;
        }
        int nanos = timestamp.getNanos();
        long seconds = timestamp.getSeconds();
        if (nanos - 1 >= 0) {
            return Timestamp.ofTimeSecondsAndNanos((long)seconds, (int)(nanos - 1));
        }
        return Timestamp.ofTimeSecondsAndNanos((long)(seconds - 1L), (int)(NANOS_PER_SECOND - 1));
    }
}

