/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.dofn;

import com.google.cloud.Timestamp;
import java.io.Serializable;
import java.util.Optional;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.DaoFactory;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.PartitionMetadataDao;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.mapper.MapperFactory;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.InitialPartition;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.transforms.DoFn;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class InitializeDoFn
extends DoFn<byte[], PartitionMetadata>
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -8921188388649003102L;
    private static final @UnknownKeyFor @NonNull @Initialized long DEFAULT_HEARTBEAT_MILLIS = 2000L;
    private final @UnknownKeyFor @NonNull @Initialized DaoFactory daoFactory;
    private final @UnknownKeyFor @NonNull @Initialized MapperFactory mapperFactory;
    private final @UnknownKeyFor @NonNull @Initialized Timestamp startTimestamp;
    private final @UnknownKeyFor @NonNull @Initialized Timestamp endTimestamp;

    public InitializeDoFn(@UnknownKeyFor @NonNull @Initialized DaoFactory daoFactory, @UnknownKeyFor @NonNull @Initialized MapperFactory mapperFactory, @UnknownKeyFor @NonNull @Initialized Timestamp startTimestamp, @UnknownKeyFor @NonNull @Initialized Timestamp endTimestamp) {
        this.daoFactory = daoFactory;
        this.mapperFactory = mapperFactory;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
    }

    @DoFn.ProcessElement
    public void processElement(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized PartitionMetadata> receiver) {
        PartitionMetadataDao partitionMetadataDao = this.daoFactory.getPartitionMetadataDao();
        if (!partitionMetadataDao.tableExists()) {
            this.daoFactory.getPartitionMetadataAdminDao().createPartitionMetadataTable();
            this.createFakeParentPartition();
        }
        PartitionMetadata initialPartition = Optional.ofNullable(partitionMetadataDao.getPartition("Parent0")).map(this.mapperFactory.partitionMetadataMapper()::from).orElseThrow(() -> new IllegalStateException("Initial partition not found in metadata table."));
        receiver.output((Object)initialPartition);
    }

    private void createFakeParentPartition() {
        PartitionMetadata parentPartition = PartitionMetadata.newBuilder().setPartitionToken("Parent0").setParentTokens(InitialPartition.PARENT_TOKENS).setStartTimestamp(this.startTimestamp).setEndTimestamp(this.endTimestamp).setHeartbeatMillis(2000L).setState(PartitionMetadata.State.CREATED).setWatermark(this.startTimestamp).build();
        this.daoFactory.getPartitionMetadataDao().insert(parentPartition);
    }
}

