/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.TextualIntegerCoder;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareIOError;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class HealthcareIOErrorCoder<@UnknownKeyFor T>
extends CustomCoder<HealthcareIOError<T>> {
    private final @UnknownKeyFor @NonNull @Initialized Coder<T> originalCoder;
    private static final @UnknownKeyFor @NonNull @Initialized NullableCoder<@UnknownKeyFor @NonNull @Initialized String> STRING_CODER = NullableCoder.of((Coder)StringUtf8Coder.of());
    private static final @UnknownKeyFor @NonNull @Initialized NullableCoder<@UnknownKeyFor @NonNull @Initialized Integer> INTEGER_CODER = NullableCoder.of((Coder)TextualIntegerCoder.of());
    private static final @UnknownKeyFor @NonNull @Initialized NullableCoder<@UnknownKeyFor @NonNull @Initialized Instant> INSTANT_CODER = NullableCoder.of((Coder)InstantCoder.of());

    HealthcareIOErrorCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> originalCoder) {
        this.originalCoder = NullableCoder.of(originalCoder);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized HealthcareIOErrorCoder<T> of(@UnknownKeyFor @NonNull @Initialized Coder<T> originalCoder) {
        return new HealthcareIOErrorCoder<T>(originalCoder);
    }

    public void encode(@UnknownKeyFor @NonNull @Initialized HealthcareIOError<T> value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.originalCoder.encode(value.getDataResource(), outStream);
        STRING_CODER.encode((Object)value.getErrorMessage(), outStream);
        STRING_CODER.encode((Object)value.getStackTrace(), outStream);
        INSTANT_CODER.encode((Object)value.getObservedTime(), outStream);
        INTEGER_CODER.encode((Object)value.getStatusCode(), outStream);
    }

    public @UnknownKeyFor @NonNull @Initialized HealthcareIOError<T> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Object dataResource = this.originalCoder.decode(inStream);
        String errorMessage = (String)STRING_CODER.decode(inStream);
        String stackTrace = (String)STRING_CODER.decode(inStream);
        Instant observedTime = (Instant)INSTANT_CODER.decode(inStream);
        Integer statusCode = (Integer)INTEGER_CODER.decode(inStream);
        return new HealthcareIOError<Object>(dataResource, errorMessage, stackTrace, observedTime, statusCode);
    }
}

