/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2Message;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class HL7v2ReadResponse {
    @Nullable
    private final @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String metadata;
    private final @UnknownKeyFor @NonNull @Initialized HL7v2Message hl7v2Message;

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            return this.hl7v2Message.toString();
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized HL7v2ReadResponse of(@UnknownKeyFor @NonNull @Initialized String metadata, @UnknownKeyFor @NonNull @Initialized HL7v2Message hl7v2Message) {
        return new HL7v2ReadResponse(metadata, hl7v2Message);
    }

    public HL7v2ReadResponse(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String metadata, @UnknownKeyFor @NonNull @Initialized HL7v2Message hl7v2Message) {
        this.metadata = metadata;
        this.hl7v2Message = hl7v2Message;
    }

    @Nullable
    public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getMetadata() {
        return this.metadata;
    }

    public @UnknownKeyFor @NonNull @Initialized HL7v2Message getHL7v2Message() {
        return this.hl7v2Message;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HL7v2ReadResponse)) {
            return false;
        }
        HL7v2ReadResponse other = (HL7v2ReadResponse)o;
        return Objects.equals(this.metadata, other.getMetadata()) && Objects.equals(this.hl7v2Message, other.getHL7v2Message());
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.metadata, this.hl7v2Message);
    }
}

