/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySinkMetrics;
import org.apache.beam.sdk.io.gcp.bigquery.RetryManager;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.JavaFieldSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaCreate;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageApiFlushAndFinalizeDoFn
extends DoFn<KV<String, Operation>, Void> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(StorageApiFlushAndFinalizeDoFn.class);
    private final @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices;
    @javax.annotation.Nullable
    private transient @UnknownKeyFor @Nullable @Initialized BigQueryServices.WriteStreamService writeStreamService = null;
    private final @UnknownKeyFor @NonNull @Initialized Counter flushOperationsSent = Metrics.counter(StorageApiFlushAndFinalizeDoFn.class, (String)"flushOperationsSent");
    private final @UnknownKeyFor @NonNull @Initialized Counter flushOperationsSucceeded = Metrics.counter(StorageApiFlushAndFinalizeDoFn.class, (String)"flushOperationsSucceeded");
    private final @UnknownKeyFor @NonNull @Initialized Counter flushOperationsFailed = Metrics.counter(StorageApiFlushAndFinalizeDoFn.class, (String)"flushOperationsFailed");
    private final @UnknownKeyFor @NonNull @Initialized Counter flushOperationsAlreadyExists = Metrics.counter(StorageApiFlushAndFinalizeDoFn.class, (String)"flushOperationsAlreadyExists");
    private final @UnknownKeyFor @NonNull @Initialized Counter flushOperationsInvalidArgument = Metrics.counter(StorageApiFlushAndFinalizeDoFn.class, (String)"flushOperationsInvalidArgument");
    private final @UnknownKeyFor @NonNull @Initialized Distribution flushLatencyDistribution = Metrics.distribution(StorageApiFlushAndFinalizeDoFn.class, (String)"flushOperationLatencyMs");
    private final @UnknownKeyFor @NonNull @Initialized Counter finalizeOperationsSent = Metrics.counter(StorageApiFlushAndFinalizeDoFn.class, (String)"finalizeOperationsSent");
    private final @UnknownKeyFor @NonNull @Initialized Counter finalizeOperationsSucceeded = Metrics.counter(StorageApiFlushAndFinalizeDoFn.class, (String)"finalizeOperationsSucceeded");
    private final @UnknownKeyFor @NonNull @Initialized Counter finalizeOperationsFailed = Metrics.counter(StorageApiFlushAndFinalizeDoFn.class, (String)"finalizeOperationsFailed");

    public StorageApiFlushAndFinalizeDoFn(@UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices) {
        this.bqServices = bqServices;
    }

    private @UnknownKeyFor @NonNull @Initialized BigQueryServices.WriteStreamService getWriteStreamService(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.writeStreamService == null) {
            this.writeStreamService = this.bqServices.getWriteStreamService((BigQueryOptions)pipelineOptions.as(BigQueryOptions.class));
        }
        return this.writeStreamService;
    }

    @DoFn.Teardown
    public void onTeardown() {
        try {
            if (this.writeStreamService != null) {
                this.writeStreamService.close();
                this.writeStreamService = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DoFn.ProcessElement
    public void process(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions, @DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Operation> element) throws @UnknownKeyFor @NonNull @Initialized Exception {
        String streamId = (String)element.getKey();
        Operation operation = (Operation)element.getValue();
        BigQueryServices.WriteStreamService datasetService = this.getWriteStreamService(pipelineOptions);
        long offset = operation.flushOffset;
        if (offset >= 0L) {
            Instant now = Instant.now();
            RetryManager retryManager = new RetryManager(Duration.standardSeconds((long)1L), Duration.standardMinutes((long)1L), 3, BigQuerySinkMetrics.throttledTimeCounter(BigQuerySinkMetrics.RpcMethod.FLUSH_ROWS));
            retryManager.addOperation(c -> {
                try {
                    this.flushOperationsSent.inc();
                    return datasetService.flush(streamId, offset);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, contexts -> {
                RetryManager.Operation.Context failedContext = (RetryManager.Operation.Context)Preconditions.checkArgumentNotNull((Object)((RetryManager.Operation.Context)Iterables.getFirst((Iterable)contexts, null)));
                Throwable error = failedContext.getError();
                LOG.warn("Flush of stream " + streamId + " to offset " + offset + " failed with " + error);
                this.flushOperationsFailed.inc();
                BigQuerySinkMetrics.reportFailedRPCMetrics(failedContext, BigQuerySinkMetrics.RpcMethod.FLUSH_ROWS);
                if (error instanceof ApiException) {
                    StatusCode.Code statusCode = ((ApiException)error).getStatusCode().getCode();
                    if (statusCode.equals((Object)StatusCode.Code.ALREADY_EXISTS)) {
                        this.flushOperationsAlreadyExists.inc();
                        return RetryManager.RetryType.DONT_RETRY;
                    }
                    if (statusCode.equals((Object)StatusCode.Code.INVALID_ARGUMENT)) {
                        this.flushOperationsInvalidArgument.inc();
                        return RetryManager.RetryType.DONT_RETRY;
                    }
                    if (statusCode.equals((Object)StatusCode.Code.NOT_FOUND)) {
                        return RetryManager.RetryType.DONT_RETRY;
                    }
                }
                return RetryManager.RetryType.RETRY_ALL_OPERATIONS;
            }, c -> {
                BigQuerySinkMetrics.reportSuccessfulRpcMetrics(c, BigQuerySinkMetrics.RpcMethod.FLUSH_ROWS);
                this.flushOperationsSucceeded.inc();
            }, new RetryManager.Operation.Context());
            retryManager.run(true);
            java.time.Duration timeElapsed = java.time.Duration.between(now, Instant.now());
            this.flushLatencyDistribution.update(timeElapsed.toMillis());
        }
        if (operation.finalizeStream) {
            RetryManager retryManager = new RetryManager(Duration.standardSeconds((long)1L), Duration.standardMinutes((long)1L), 3, BigQuerySinkMetrics.throttledTimeCounter(BigQuerySinkMetrics.RpcMethod.FINALIZE_STREAM));
            retryManager.addOperation(c -> {
                this.finalizeOperationsSent.inc();
                return datasetService.finalizeWriteStream(streamId);
            }, contexts -> {
                StatusCode.Code statusCode;
                Throwable error;
                LOG.warn("Finalize of stream " + streamId + " failed with " + ((RetryManager.Operation.Context)Preconditions.checkArgumentNotNull((Object)((RetryManager.Operation.Context)Iterables.getFirst((Iterable)contexts, null)))).getError());
                this.finalizeOperationsFailed.inc();
                RetryManager.Operation.Context firstContext = (RetryManager.Operation.Context)Iterables.getFirst((Iterable)contexts, null);
                BigQuerySinkMetrics.reportFailedRPCMetrics(firstContext, BigQuerySinkMetrics.RpcMethod.FINALIZE_STREAM);
                Throwable throwable = error = firstContext == null ? null : firstContext.getError();
                if (error instanceof ApiException && (statusCode = ((ApiException)error).getStatusCode().getCode()).equals((Object)StatusCode.Code.NOT_FOUND)) {
                    return RetryManager.RetryType.DONT_RETRY;
                }
                return RetryManager.RetryType.RETRY_ALL_OPERATIONS;
            }, r -> {
                BigQuerySinkMetrics.reportSuccessfulRpcMetrics(r, BigQuerySinkMetrics.RpcMethod.FINALIZE_STREAM);
                this.finalizeOperationsSucceeded.inc();
            }, new RetryManager.Operation.Context());
            retryManager.run(true);
        }
    }

    @DefaultSchema(value=JavaFieldSchema.class)
    static class Operation
    implements Comparable<Operation>,
    Serializable {
        final @UnknownKeyFor @NonNull @Initialized long flushOffset;
        final @UnknownKeyFor @NonNull @Initialized boolean finalizeStream;

        @SchemaCreate
        public Operation(@UnknownKeyFor @NonNull @Initialized long flushOffset, @UnknownKeyFor @NonNull @Initialized boolean finalizeStream) {
            this.flushOffset = flushOffset;
            this.finalizeStream = finalizeStream;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Operation operation = (Operation)o;
            return this.flushOffset == operation.flushOffset && this.finalizeStream == operation.finalizeStream;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.flushOffset, this.finalizeStream);
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int compareTo(@UnknownKeyFor @NonNull @Initialized Operation other) {
            int compValue = Long.compare(this.flushOffset, other.flushOffset);
            if (compValue == 0) {
                compValue = Boolean.compare(this.finalizeStream, other.finalizeStream);
            }
            return compValue;
        }
    }
}

