/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.testing.FakeBigQueryServices;
import org.apache.beam.sdk.io.gcp.testing.FakeDatasetService;
import org.apache.beam.sdk.io.gcp.testing.FakeJobService;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.SchemaIO;
import org.apache.beam.sdk.schemas.io.SchemaIOProvider;
import org.apache.beam.sdk.schemas.transforms.Convert;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

@Internal
@AutoService(value={SchemaIOProvider.class})
public class BigQuerySchemaIOProvider
implements SchemaIOProvider {
    private static final @UnknownKeyFor @NonNull @Initialized HashMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition> createDispositionsMap = new HashMap();

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "bigquery";
    }

    public @UnknownKeyFor @NonNull @Initialized Schema configurationSchema() {
        return Schema.builder().addNullableField("table", Schema.FieldType.STRING).addNullableField("query", Schema.FieldType.STRING).addNullableField("queryLocation", Schema.FieldType.STRING).addNullableField("createDisposition", Schema.FieldType.STRING).addNullableField("useTestingBigQueryServices", Schema.FieldType.BOOLEAN).addNullableField("autoSharding", Schema.FieldType.BOOLEAN).build();
    }

    public @UnknownKeyFor @NonNull @Initialized BigQuerySchemaIO from(@UnknownKeyFor @NonNull @Initialized String location, @UnknownKeyFor @NonNull @Initialized Row configuration, @Nullable @UnknownKeyFor @Initialized Schema dataSchema) {
        return new BigQuerySchemaIO(location, configuration);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean requiresDataSchema() {
        return false;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.BOUNDED;
    }

    static {
        createDispositionsMap.put("Never", BigQueryIO.Write.CreateDisposition.CREATE_NEVER);
        createDispositionsMap.put("IfNeeded", BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED);
    }

    static class BigQuerySchemaIO
    implements SchemaIO,
    Serializable {
        protected final @UnknownKeyFor @NonNull @Initialized Row config;
        protected final @UnknownKeyFor @NonNull @Initialized String location;

        BigQuerySchemaIO(@UnknownKeyFor @NonNull @Initialized String location, @UnknownKeyFor @NonNull @Initialized Row config) {
            this.config = config;
            this.location = location;
        }

        public @UnknownKeyFor @NonNull @Initialized Schema schema() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> buildReader() {
            return new PTransform<PBegin, PCollection<Row>>(){

                public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
                    String queryLocation;
                    String query;
                    BigQueryIO.TypedRead<TableRow> read = BigQueryIO.readTableRowsWithSchema();
                    read = read.withMethod(BigQueryIO.TypedRead.Method.EXPORT);
                    String table = config.getString("table");
                    if (table != null) {
                        read = read.from(table);
                    }
                    if ((query = config.getString("query")) != null) {
                        read = read.fromQuery(query).usingStandardSql();
                    }
                    if ((queryLocation = config.getString("queryLocation")) != null) {
                        read = read.withQueryLocation(queryLocation);
                    }
                    return (PCollection)((PCollection)input.apply(read)).apply(Convert.toRows());
                }
            };
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PDone> buildWriter() {
            return new PTransform<PCollection<Row>, PDone>(){

                public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
                    String createDisposition;
                    String table;
                    Boolean useTestingBigQueryServices;
                    BigQueryIO.Write write = BigQueryIO.write().useBeamSchema().withMethod(BigQueryIO.Write.Method.STORAGE_WRITE_API).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_APPEND);
                    Boolean autoSharding = config.getBoolean("autoSharding");
                    if (input.isBounded() == PCollection.IsBounded.UNBOUNDED) {
                        write = write.withTriggeringFrequency(Duration.standardSeconds((long)5L));
                        if (autoSharding == null || autoSharding.booleanValue()) {
                            write = write.withAutoSharding();
                        }
                    }
                    if ((useTestingBigQueryServices = config.getBoolean("useTestingBigQueryServices")) != null && useTestingBigQueryServices.booleanValue()) {
                        FakeBigQueryServices fbqs = new FakeBigQueryServices().withDatasetService(new FakeDatasetService()).withJobService(new FakeJobService());
                        write = write.withTestServices(fbqs);
                    }
                    if ((table = config.getString("table")) != null) {
                        write = write.to(table);
                    }
                    if ((createDisposition = config.getString("createDisposition")) != null && createDispositionsMap.containsKey(createDisposition)) {
                        write = write.withCreateDisposition((BigQueryIO.Write.CreateDisposition)((Object)createDispositionsMap.get(createDisposition)));
                    }
                    input.apply(write);
                    return PDone.in((Pipeline)input.getPipeline());
                }
            };
        }
    }
}

