/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.function.ToIntFunction;
import net.openhft.chronicle.core.io.SimpleCloseable;
import net.openhft.chronicle.queue.impl.single.DirectoryListing;

final class FileSystemDirectoryListing
extends SimpleCloseable
implements DirectoryListing {
    private final File queueDir;
    private final ToIntFunction<File> fileToCycleFunction;
    private int minCreatedCycle = Integer.MAX_VALUE;
    private int maxCreatedCycle = Integer.MIN_VALUE;

    FileSystemDirectoryListing(File queueDir, ToIntFunction<File> fileToCycleFunction) {
        this.queueDir = queueDir;
        this.fileToCycleFunction = fileToCycleFunction;
    }

    @Override
    public void onFileCreated(File file, int cycle) {
    }

    @Override
    public void refresh(boolean force) {
        int minCycle = Integer.MAX_VALUE;
        int maxCycle = Integer.MIN_VALUE;
        File[] files = this.queueDir.listFiles((d, n) -> n.endsWith(".cq4"));
        if (files != null) {
            for (File file : files) {
                int cycle = this.fileToCycleFunction.applyAsInt(file);
                minCycle = Math.min(minCycle, cycle);
                maxCycle = Math.max(maxCycle, cycle);
            }
        }
        this.minCreatedCycle = minCycle;
        this.maxCreatedCycle = maxCycle;
    }

    @Override
    public int getMinCreatedCycle() {
        return this.minCreatedCycle;
    }

    @Override
    public int getMaxCreatedCycle() {
        return this.maxCreatedCycle;
    }

    @Override
    public long modCount() {
        return -1L;
    }
}

