/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

import com.microsoft.azure.eventprocessorhost.Checkpoint;
import com.microsoft.azure.eventprocessorhost.CompleteLease;
import com.microsoft.azure.eventprocessorhost.HostContext;
import com.microsoft.azure.eventprocessorhost.ICheckpointManager;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryCheckpointManager
implements ICheckpointManager {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(InMemoryCheckpointManager.class);
    private HostContext hostContext;

    public void initialize(HostContext hostContext) {
        this.hostContext = hostContext;
    }

    @Override
    public CompletableFuture<Boolean> checkpointStoreExists() {
        boolean exists = InMemoryCheckpointStore.SINGLETON.existsMap();
        TRACE_LOGGER.debug(this.hostContext.withHost("checkpointStoreExists() " + exists));
        return CompletableFuture.completedFuture(exists);
    }

    @Override
    public CompletableFuture<Void> createCheckpointStoreIfNotExists() {
        TRACE_LOGGER.debug(this.hostContext.withHost("createCheckpointStoreIfNotExists()"));
        InMemoryCheckpointStore.SINGLETON.initializeMap();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> deleteCheckpointStore() {
        TRACE_LOGGER.debug(this.hostContext.withHost("deleteCheckpointStore()"));
        InMemoryCheckpointStore.SINGLETON.deleteMap();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Checkpoint> getCheckpoint(String partitionId) {
        Checkpoint returnCheckpoint = null;
        Checkpoint checkpointInStore = InMemoryCheckpointStore.SINGLETON.getCheckpoint(partitionId);
        if (checkpointInStore == null) {
            TRACE_LOGGER.warn(this.hostContext.withHostAndPartition(partitionId, "getCheckpoint() no existing Checkpoint"));
            returnCheckpoint = null;
        } else if (checkpointInStore.getSequenceNumber() == -1L) {
            TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(partitionId, "getCheckpoint() uninitalized"));
            returnCheckpoint = null;
        } else {
            TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(partitionId, "getCheckpoint() found " + checkpointInStore.getOffset() + "//" + checkpointInStore.getSequenceNumber()));
            returnCheckpoint = new Checkpoint(checkpointInStore);
        }
        return CompletableFuture.completedFuture(returnCheckpoint);
    }

    @Override
    public CompletableFuture<Void> createAllCheckpointsIfNotExists(List<String> partitionIds) {
        for (String id : partitionIds) {
            Checkpoint checkpointInStore = InMemoryCheckpointStore.SINGLETON.getCheckpoint(id);
            if (checkpointInStore != null) {
                TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(id, "createCheckpointIfNotExists() found existing checkpoint, OK"));
                continue;
            }
            TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(id, "createCheckpointIfNotExists() creating new checkpoint"));
            Checkpoint newStoreCheckpoint = new Checkpoint(id);
            newStoreCheckpoint.setOffset(null);
            newStoreCheckpoint.setSequenceNumber(-1L);
            InMemoryCheckpointStore.SINGLETON.setOrReplaceCheckpoint(newStoreCheckpoint);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> updateCheckpoint(CompleteLease lease, Checkpoint checkpoint) {
        TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(checkpoint.getPartitionId(), "updateCheckpoint() " + checkpoint.getOffset() + "//" + checkpoint.getSequenceNumber()));
        Checkpoint checkpointInStore = InMemoryCheckpointStore.SINGLETON.getCheckpoint(checkpoint.getPartitionId());
        if (checkpointInStore != null) {
            checkpointInStore.setOffset(checkpoint.getOffset());
            checkpointInStore.setSequenceNumber(checkpoint.getSequenceNumber());
        } else {
            TRACE_LOGGER.warn(this.hostContext.withHostAndPartition(checkpoint.getPartitionId(), "updateCheckpoint() can't find checkpoint"));
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> deleteCheckpoint(String partitionId) {
        TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(partitionId, "deleteCheckpoint()"));
        InMemoryCheckpointStore.SINGLETON.removeCheckpoint(partitionId);
        return CompletableFuture.completedFuture(null);
    }

    private static class InMemoryCheckpointStore {
        static final InMemoryCheckpointStore SINGLETON = new InMemoryCheckpointStore();
        private ConcurrentHashMap<String, Checkpoint> inMemoryCheckpointsPrivate = null;

        private InMemoryCheckpointStore() {
        }

        synchronized boolean existsMap() {
            return this.inMemoryCheckpointsPrivate != null;
        }

        synchronized void initializeMap() {
            if (this.inMemoryCheckpointsPrivate == null) {
                this.inMemoryCheckpointsPrivate = new ConcurrentHashMap();
            }
        }

        synchronized void deleteMap() {
            this.inMemoryCheckpointsPrivate = null;
        }

        synchronized Checkpoint getCheckpoint(String partitionId) {
            return this.inMemoryCheckpointsPrivate.get(partitionId);
        }

        synchronized void setOrReplaceCheckpoint(Checkpoint newCheckpoint) {
            this.inMemoryCheckpointsPrivate.put(newCheckpoint.getPartitionId(), newCheckpoint);
        }

        synchronized void removeCheckpoint(String partitionId) {
            this.inMemoryCheckpointsPrivate.remove(partitionId);
        }
    }
}

