/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar;

import com.github.junrar.Archive;
import com.github.junrar.ContentDescription;
import com.github.junrar.LocalFolderExtractor;
import com.github.junrar.exception.RarException;
import com.github.junrar.rarfile.FileHeader;
import com.github.junrar.volume.VolumeManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Junrar {
    private static final Logger logger = LoggerFactory.getLogger(Junrar.class);

    public static List<File> extract(String rarPath, String destinationPath) throws IOException, RarException {
        return Junrar.extract(rarPath, destinationPath, null);
    }

    public static List<File> extract(String rarPath, String destinationPath, String password) throws IOException, RarException {
        if (rarPath == null || destinationPath == null) {
            throw new IllegalArgumentException("archive and destination must be set");
        }
        return Junrar.extract(new File(rarPath), new File(destinationPath), password);
    }

    public static List<File> extract(File rar, File destinationFolder) throws RarException, IOException {
        return Junrar.extract(rar, destinationFolder, null);
    }

    public static List<File> extract(File rar, File destinationFolder, String password) throws RarException, IOException {
        Junrar.validateRarPath(rar);
        Junrar.validateDestinationPath(destinationFolder);
        Archive archive = Junrar.createArchiveOrThrowException(rar, password);
        LocalFolderExtractor lfe = new LocalFolderExtractor(destinationFolder);
        return Junrar.extractArchiveTo(archive, lfe);
    }

    public static List<File> extract(InputStream resourceAsStream, File destinationFolder) throws RarException, IOException {
        return Junrar.extract(resourceAsStream, destinationFolder, null);
    }

    public static List<File> extract(InputStream resourceAsStream, File destinationFolder, String password) throws RarException, IOException {
        Junrar.validateDestinationPath(destinationFolder);
        Archive arch = Junrar.createArchiveOrThrowException(resourceAsStream, password);
        LocalFolderExtractor lfe = new LocalFolderExtractor(destinationFolder);
        return Junrar.extractArchiveTo(arch, lfe);
    }

    public static List<File> extract(VolumeManager volumeManager, File destinationFolder) throws IOException, RarException {
        Junrar.validateDestinationPath(destinationFolder);
        Archive arch = Junrar.createArchiveOrThrowException(volumeManager, null);
        LocalFolderExtractor lfe = new LocalFolderExtractor(destinationFolder);
        return Junrar.extractArchiveTo(arch, lfe);
    }

    public static List<File> extract(VolumeManager volumeManager, File destinationFolder, String password) throws IOException, RarException {
        Junrar.validateDestinationPath(destinationFolder);
        Archive arch = Junrar.createArchiveOrThrowException(volumeManager, password);
        LocalFolderExtractor lfe = new LocalFolderExtractor(destinationFolder);
        return Junrar.extractArchiveTo(arch, lfe);
    }

    public static List<ContentDescription> getContentsDescription(File rar) throws RarException, IOException {
        Junrar.validateRarPath(rar);
        Archive arch = Junrar.createArchiveOrThrowException(rar, null);
        return Junrar.getContentsDescriptionFromArchive(arch);
    }

    public static List<ContentDescription> getContentsDescription(InputStream resourceAsStream) throws RarException, IOException {
        Archive arch = Junrar.createArchiveOrThrowException(resourceAsStream, null);
        return Junrar.getContentsDescriptionFromArchive(arch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ContentDescription> getContentsDescriptionFromArchive(Archive arch) throws RarException, IOException {
        ArrayList<ContentDescription> contents = new ArrayList<ContentDescription>();
        try {
            if (arch.isEncrypted()) {
                logger.warn("archive is encrypted cannot extract");
                ArrayList<ContentDescription> arrayList = new ArrayList<ContentDescription>();
                return arrayList;
            }
            for (FileHeader fileHeader : arch) {
                contents.add(new ContentDescription(fileHeader.getFileName(), fileHeader.getUnpSize()));
            }
        }
        finally {
            arch.close();
        }
        return contents;
    }

    private static Archive createArchiveOrThrowException(VolumeManager volumeManager, String password) throws RarException, IOException {
        try {
            return new Archive(volumeManager, null, password);
        }
        catch (RarException | IOException e) {
            logger.error("Error while creating archive", (Throwable)e);
            throw e;
        }
    }

    private static Archive createArchiveOrThrowException(InputStream rarAsStream, String password) throws RarException, IOException {
        try {
            return new Archive(rarAsStream, password);
        }
        catch (RarException | IOException e) {
            logger.error("Error while creating archive", (Throwable)e);
            throw e;
        }
    }

    private static Archive createArchiveOrThrowException(File file, String password) throws RarException, IOException {
        try {
            return new Archive(file, password);
        }
        catch (RarException | IOException e) {
            logger.error("Error while creating archive", (Throwable)e);
            throw e;
        }
    }

    private static void validateDestinationPath(File destinationFolder) {
        if (destinationFolder == null) {
            throw new IllegalArgumentException("archive and destination must me set");
        }
        if (!destinationFolder.exists() || !destinationFolder.isDirectory()) {
            throw new IllegalArgumentException("the destination must exist and point to a directory: " + destinationFolder);
        }
    }

    private static void validateRarPath(File rar) {
        if (rar == null) {
            throw new IllegalArgumentException("archive and destination must me set");
        }
        if (!rar.exists()) {
            throw new IllegalArgumentException("the archive does not exit: " + rar);
        }
        if (!rar.isFile()) {
            throw new IllegalArgumentException("First argument should be a file but was " + rar.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<File> extractArchiveTo(Archive arch, LocalFolderExtractor destination) throws IOException, RarException {
        ArrayList<File> extractedFiles = new ArrayList<File>();
        try {
            for (FileHeader fh : arch) {
                try {
                    File file = Junrar.tryToExtract(destination, arch, fh);
                    if (file == null) continue;
                    extractedFiles.add(file);
                }
                catch (RarException | IOException e) {
                    logger.error("error extracting the file", (Throwable)e);
                    throw e;
                    return extractedFiles;
                }
            }
        }
        finally {
            arch.close();
        }
    }

    private static File tryToExtract(LocalFolderExtractor destination, Archive arch, FileHeader fileHeader) throws IOException, RarException {
        String fileNameString = fileHeader.getFileName();
        logger.info("extracting: {}", (Object)fileNameString);
        if (fileHeader.isDirectory()) {
            return destination.createDirectory(fileHeader);
        }
        return destination.extract(arch, fileHeader);
    }
}

