/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import org.python.core.JyAttribute;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyJavaType;
import org.python.core.PyMethod;
import org.python.core.PyObject;
import org.python.core.PyProxy;
import org.python.core.PyReflectedFunction;
import org.python.core.PyType;
import org.python.core.ReflectedArgs;
import org.python.core.ReflectedCallData;
import org.python.core.ThreadContext;
import org.python.core.Untraversable;

@Untraversable
public class PyReflectedConstructor
extends PyReflectedFunction {
    public PyReflectedConstructor(String name) {
        super(name);
    }

    public PyReflectedConstructor(Constructor<?> c) {
        this(c.getDeclaringClass().getName());
        this.addConstructor(c);
    }

    private ReflectedArgs makeArgs(Constructor<?> m) {
        return new ReflectedArgs(m, m.getParameterTypes(), m.getDeclaringClass(), true, m.isVarArgs());
    }

    public void addConstructor(Constructor<?> m) {
        int mods = m.getModifiers();
        if (!Modifier.isPublic(mods) && Options.respectJavaAccessibility) {
            return;
        }
        this.addArgs(this.makeArgs(m));
    }

    PyObject make(PyObject[] args, String[] keywords) {
        PyObject obj;
        ReflectedCallData callData = new ReflectedCallData();
        Member method = null;
        boolean consumes_keywords = false;
        PyObject[] allArgs = null;
        if (this.nargs > 0) {
            if (this.argslist[0].matches(null, args, keywords, callData)) {
                method = this.argslist[0].method;
                consumes_keywords = this.argslist[0].flags == 2;
            } else {
                allArgs = args;
                int i = 1;
                if (keywords.length > 0) {
                    args = new PyObject[allArgs.length - keywords.length];
                    System.arraycopy(allArgs, 0, args, 0, args.length);
                    i = 0;
                }
                while (i < this.nargs) {
                    if (this.argslist[i].matches(null, args, Py.NoKeywords, callData)) {
                        method = this.argslist[i].method;
                        break;
                    }
                    ++i;
                }
            }
        }
        if (method == null) {
            this.throwError(callData.errArg, args.length, true, false);
        }
        try {
            obj = (PyObject)((Constructor)method).newInstance(callData.getArgsArray());
        }
        catch (Throwable t) {
            throw Py.JavaError(t);
        }
        if (!consumes_keywords) {
            int offset = args.length;
            for (int i = 0; i < keywords.length; ++i) {
                obj.__setattr__(keywords[i], allArgs[i + offset]);
            }
        }
        return obj;
    }

    @Override
    public PyObject __call__(PyObject self, PyObject[] args, String[] keywords) {
        int i;
        int i2;
        Class<?> declaringClass;
        if (self == null) {
            throw Py.TypeError("invalid self argument to constructor");
        }
        Class<?> javaClass = self.getType().getProxyType();
        if (javaClass == null) {
            throw Py.TypeError("self invalid - must be a Java subclass [self=" + self + "]");
        }
        Class<?> clazz = declaringClass = this.argslist[0] == null ? null : this.argslist[0].declaringClass;
        if (!(declaringClass != null && PyProxy.class.isAssignableFrom(declaringClass) || self.getType() instanceof PyJavaType)) {
            return PyType.fromClass(javaClass).lookup("__init__").__call__(self, args, keywords);
        }
        if (this.nargs == 0) {
            throw Py.TypeError("No visible constructors for class (" + javaClass.getName() + ")");
        }
        if (!declaringClass.isAssignableFrom(javaClass)) {
            throw Py.TypeError("self invalid - must implement: " + declaringClass.getName());
        }
        int mods = declaringClass.getModifiers();
        if (Modifier.isInterface(mods)) {
            throw Py.TypeError("can't instantiate interface (" + declaringClass.getName() + ")");
        }
        if (Modifier.isAbstract(mods)) {
            throw Py.TypeError("can't instantiate abstract class (" + declaringClass.getName() + ")");
        }
        if (JyAttribute.hasAttr(self, (byte)-128)) {
            Class<?> sup = javaClass;
            if (PyProxy.class.isAssignableFrom(sup)) {
                sup = sup.getSuperclass();
            }
            throw Py.TypeError("instance already instantiated for " + sup.getName());
        }
        ReflectedCallData callData = new ReflectedCallData();
        Member method = null;
        int nkeywords = keywords.length;
        ReflectedArgs rargs = null;
        PyObject[] allArgs = args;
        boolean usingKeywordArgsCtor = false;
        if (nkeywords > 0) {
            int n = this.nargs;
            for (i2 = 0; i2 < n; ++i2) {
                rargs = this.argslist[i2];
                if (!rargs.matches(null, args, keywords, callData)) continue;
                method = rargs.method;
                break;
            }
            if (method != null) {
                usingKeywordArgsCtor = true;
            } else {
                args = new PyObject[allArgs.length - nkeywords];
                System.arraycopy(allArgs, 0, args, 0, args.length);
                Member varargMatch = null;
                ReflectedCallData varargData = null;
                for (i = 0; i < n; ++i) {
                    rargs = this.argslist[i];
                    if (!rargs.matches(null, args, Py.NoKeywords, callData)) continue;
                    if (!this.argslist[i].isVarArgs) {
                        method = this.argslist[i].method;
                        break;
                    }
                    varargMatch = this.argslist[i].method;
                    varargData = callData;
                    callData = new ReflectedCallData();
                }
                if (method == null && varargMatch != null) {
                    method = varargMatch;
                    callData = varargData;
                }
            }
        } else {
            Member varargMatch = null;
            ReflectedCallData varargData = null;
            int n = this.nargs;
            for (i = 0; i < n; ++i) {
                rargs = this.argslist[i];
                if (!rargs.matches(null, args, Py.NoKeywords, callData)) continue;
                if (!this.argslist[i].isVarArgs) {
                    method = this.argslist[i].method;
                    break;
                }
                varargMatch = this.argslist[i].method;
                varargData = callData;
                callData = new ReflectedCallData();
            }
            if (method == null && varargMatch != null) {
                method = varargMatch;
                callData = varargData;
            }
        }
        if (method == null) {
            this.throwError(callData.errArg, args.length, false, false);
        }
        this.constructProxy(self, (Constructor)method, callData.getArgsArray(), javaClass);
        if (!usingKeywordArgsCtor) {
            int offset = args.length;
            for (i2 = 0; i2 < nkeywords; ++i2) {
                self.__setattr__(keywords[i2], allArgs[i2 + offset]);
            }
        }
        return Py.None;
    }

    @Override
    public PyObject __call__(PyObject[] args, String[] keywords) {
        if (args.length < 1) {
            throw Py.TypeError("constructor requires self argument");
        }
        PyObject[] newArgs = new PyObject[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, newArgs.length);
        return this.__call__(args[0], newArgs, keywords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void constructProxy(PyObject obj, Constructor<?> ctor, Object[] args, Class<?> proxy) {
        Object jself = null;
        Object[] previous = ThreadContext.initializingProxy.get();
        ThreadContext.initializingProxy.set(new Object[]{obj});
        try {
            try {
                jself = ctor.newInstance(args);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof InstantiationException) {
                    Class<?> sup = proxy.getSuperclass();
                    String msg = "Constructor failed for Java superclass";
                    if (sup != null) {
                        msg = msg + " " + sup.getName();
                    }
                    throw Py.TypeError(msg);
                }
                throw Py.JavaError(e);
            }
            catch (Throwable t) {
                throw Py.JavaError(t);
            }
        }
        finally {
            ThreadContext.initializingProxy.set(previous);
        }
        JyAttribute.setAttr(obj, (byte)-128, jself);
    }

    @Override
    public PyObject _doget(PyObject container, PyObject wherefound) {
        if (container == null) {
            return this;
        }
        return new PyMethod(this, container, wherefound);
    }

    @Override
    public String toString() {
        return "<java constructor " + this.__name__ + " " + Py.idstr(this) + ">";
    }
}

