/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.cert.crmf;

import java.util.Collection;
import org.python.bouncycastle.asn1.cmp.CMPCertificate;
import org.python.bouncycastle.asn1.cmp.CertResponse;
import org.python.bouncycastle.asn1.cmp.CertifiedKeyPair;
import org.python.bouncycastle.asn1.cms.ContentInfo;
import org.python.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.python.bouncycastle.cms.CMSEnvelopedData;
import org.python.bouncycastle.cms.CMSException;
import org.python.bouncycastle.cms.Recipient;
import org.python.bouncycastle.cms.RecipientInformation;
import org.python.bouncycastle.cms.RecipientInformationStore;

public class CertificateResponse {
    private final CertResponse certResponse;

    public CertificateResponse(CertResponse certResponse) {
        this.certResponse = certResponse;
    }

    public boolean hasEncryptedCertificate() {
        return this.certResponse.getCertifiedKeyPair().getCertOrEncCert().hasEncryptedCertificate();
    }

    public CMSEnvelopedData getEncryptedCertificate() throws CMSException {
        if (!this.hasEncryptedCertificate()) {
            throw new IllegalStateException("encrypted certificate asked for, none found");
        }
        CertifiedKeyPair certifiedKeyPair = this.certResponse.getCertifiedKeyPair();
        CMSEnvelopedData cMSEnvelopedData = new CMSEnvelopedData(new ContentInfo(PKCSObjectIdentifiers.envelopedData, certifiedKeyPair.getCertOrEncCert().getEncryptedCert().getValue()));
        if (cMSEnvelopedData.getRecipientInfos().size() != 1) {
            throw new IllegalStateException("data encrypted for more than one recipient");
        }
        return cMSEnvelopedData;
    }

    public CMPCertificate getCertificate(Recipient recipient) throws CMSException {
        CMSEnvelopedData cMSEnvelopedData = this.getEncryptedCertificate();
        RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
        Collection<RecipientInformation> collection = recipientInformationStore.getRecipients();
        RecipientInformation recipientInformation = collection.iterator().next();
        return CMPCertificate.getInstance((Object)recipientInformation.getContent(recipient));
    }

    public CMPCertificate getCertificate() throws CMSException {
        if (this.hasEncryptedCertificate()) {
            throw new IllegalStateException("plaintext certificate asked for, none found");
        }
        return this.certResponse.getCertifiedKeyPair().getCertOrEncCert().getCertificate();
    }

    public CertResponse toASN1Structure() {
        return this.certResponse;
    }
}

