/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.parser;

import com.sforce.ws.ConnectionException;
import com.sforce.ws.parser.MXParser;
import com.sforce.ws.parser.PullParserException;
import com.sforce.ws.parser.XmlPullParserException;
import java.io.IOException;
import java.io.InputStream;

public final class XmlInputStream {
    private MXParser parser = new MXParser();
    public static final int END_DOCUMENT = 1;
    public static final int START_DOCUMENT = 0;
    public static final int START_TAG = 2;
    public static final int END_TAG = 3;
    public static final int TEXT = 4;
    private static final int EMPTY = -99999;
    private int peekTag = -99999;

    public XmlInputStream() {
        try {
            this.parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        }
        catch (XmlPullParserException e) {
            throw new InternalError("Unable to set feature:" + e);
        }
    }

    public void setInput(InputStream inputStream, String inputEncoding) throws PullParserException {
        this.parser.setInput(inputStream, inputEncoding);
    }

    public String getNamespace(String prefix) {
        return this.parser.getNamespace(prefix);
    }

    public String getPositionDescription() {
        return this.parser.getPositionDescription();
    }

    public int getLineNumber() {
        return this.parser.getLineNumber();
    }

    public int getColumnNumber() {
        return this.parser.getColumnNumber();
    }

    public String getNamespace() {
        return this.parser.getNamespace();
    }

    public String getName() {
        return this.parser.getName();
    }

    public String getAttributeValue(String namespace, String name) {
        return this.parser.getAttributeValue(namespace, name);
    }

    public int getAttributeCount() {
        return this.parser.getAttributeCount();
    }

    public String getAttributeValue(int index) {
        return this.parser.getAttributeValue(index);
    }

    public String getAttributeName(int index) {
        return this.parser.getAttributeName(index);
    }

    public String getAttributeNamespace(int index) {
        return this.parser.getAttributeNamespace(index);
    }

    public void consumePeeked() {
        this.peekTag = -99999;
    }

    public int getEventType() throws ConnectionException {
        if (this.peekTag != -99999) {
            return this.peekTag;
        }
        try {
            return this.parser.getEventType();
        }
        catch (XmlPullParserException e) {
            throw new ConnectionException("Failed to get event type", e);
        }
    }

    public int next() throws IOException, ConnectionException {
        if (this.peekTag != -99999) {
            int t = this.peekTag;
            this.peekTag = -99999;
            return t;
        }
        try {
            return this.parser.next();
        }
        catch (XmlPullParserException e) {
            throw new ConnectionException("Found invalid XML. " + e.getMessage(), e);
        }
    }

    public String toString() {
        return this.parser.getPositionDescription();
    }

    public String nextText() throws IOException, ConnectionException {
        try {
            return this.parser.nextText();
        }
        catch (XmlPullParserException e) {
            throw new ConnectionException("Failed to get text", e);
        }
    }

    public String getText() {
        return this.parser.getText();
    }

    public int nextTag() throws IOException, ConnectionException {
        if (this.peekTag != -99999) {
            int t = this.peekTag;
            this.peekTag = -99999;
            return t;
        }
        try {
            return this.parser.nextTag();
        }
        catch (XmlPullParserException e) {
            throw new ConnectionException("Failed to get next element", e);
        }
    }

    public int peekTag() throws ConnectionException, IOException {
        if (this.peekTag != -99999) {
            return this.peekTag;
        }
        this.peekTag = this.nextTag();
        return this.peekTag;
    }

    public int peek() throws ConnectionException, IOException {
        if (this.peekTag != -99999) {
            return this.peekTag;
        }
        int peek = this.next();
        this.peekTag = peek == 2 || peek == 3 ? peek : -99999;
        return peek;
    }
}

