/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.codegen.metadata;

import com.sforce.ws.bind.NameMapper;
import com.sforce.ws.bind.TypeMapper;
import com.sforce.ws.codegen.metadata.ClassMetadata;
import com.sforce.ws.wsdl.Enumeration;
import com.sforce.ws.wsdl.Schema;
import com.sforce.ws.wsdl.SimpleType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;

public class SimpleClassMetadata
extends ClassMetadata {
    private static final Pattern DASH_PATTERN = Pattern.compile("-");
    private final Collection<EnumAndValue> enumsAndValues;

    public static Collection<EnumAndValue> getEnumsAndValues(SimpleType simpleType, TypeMapper typeMapper) {
        ArrayList<EnumAndValue> enumsAndValues = new ArrayList<EnumAndValue>();
        for (Enumeration e : simpleType.getRestriction()) {
            enumsAndValues.add(new EnumAndValue(SimpleClassMetadata.javaName(e, typeMapper), e.getValue()));
        }
        return enumsAndValues;
    }

    public static String javaName(Enumeration enumeration, TypeMapper typeMapper) {
        String subname;
        String name = enumeration.getValue();
        int index = name.indexOf(":");
        String string = subname = index == -1 ? name : name.substring(index + 1);
        if (typeMapper.isKeyWord(subname)) {
            subname = "_" + subname;
        }
        if (subname.indexOf("-") > 0) {
            subname = DASH_PATTERN.matcher(subname).replaceAll("_");
        }
        return subname;
    }

    public SimpleClassMetadata(Schema schema, SimpleType simpleType, TypeMapper typeMapper) {
        this(NameMapper.getPackageName(schema.getTargetNamespace(), typeMapper.getPackagePrefix()), NameMapper.getClassName(simpleType.getName()), SimpleClassMetadata.getEnumsAndValues(simpleType, typeMapper));
    }

    public SimpleClassMetadata(String packageName, String className, Collection<EnumAndValue> enumsAndValues) {
        super(packageName, className);
        this.enumsAndValues = enumsAndValues;
    }

    public Collection<EnumAndValue> getEnumsAndValues() {
        return this.enumsAndValues;
    }

    public static class EnumAndValue {
        public String e;
        public String v;

        public EnumAndValue(String e, String v) {
            this.e = e;
            this.v = v;
        }
    }
}

