/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.internal.avro.implementation.schema.primitive;

import com.azure.storage.internal.avro.implementation.AvroParserState;
import com.azure.storage.internal.avro.implementation.schema.AvroSchema;
import com.azure.storage.internal.avro.implementation.schema.AvroSimpleSchema;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.function.Consumer;

public class AvroFloatSchema
extends AvroSimpleSchema {
    public AvroFloatSchema(AvroParserState state, Consumer<Object> onResult) {
        super(state, onResult);
    }

    @Override
    public void pushToStack() {
        this.state.pushToStack(this);
    }

    @Override
    public void progress() {
        List<ByteBuffer> buffers = this.state.read(4L);
        byte[] floatBytes = AvroSchema.getBytes(buffers);
        int floatInt = ByteBuffer.wrap(floatBytes).order(ByteOrder.LITTLE_ENDIAN).getInt();
        this.result = Float.valueOf(Float.intBitsToFloat(floatInt));
        this.done = true;
    }

    @Override
    public boolean canProgress() {
        return this.state.sizeGreaterThan(4L);
    }
}

