/*
 * Decompiled with CFR 0.152.
 */
package io.github.spannm.jackcess.impl;

import io.github.spannm.jackcess.Column;
import io.github.spannm.jackcess.InvalidValueException;
import io.github.spannm.jackcess.expr.EvalException;
import io.github.spannm.jackcess.expr.Identifier;
import io.github.spannm.jackcess.expr.Value;
import io.github.spannm.jackcess.impl.ColEvalContext;
import io.github.spannm.jackcess.impl.ColumnImpl;
import io.github.spannm.jackcess.impl.InternalColumnValidator;
import io.github.spannm.jackcess.impl.expr.Expressionator;
import io.github.spannm.jackcess.util.ColumnValidator;
import java.io.IOException;

public class ColValidatorEvalContext
extends ColEvalContext {
    private String _helpStr;
    private Object _val;

    public ColValidatorEvalContext(ColumnImpl col) {
        super(col);
    }

    ColValidatorEvalContext withExpr(String exprStr, String helpStr) {
        this.setExpr(Expressionator.Type.FIELD_VALIDATOR, exprStr);
        this._helpStr = helpStr;
        return this;
    }

    ColumnValidator toColumnValidator(ColumnValidator delegate) {
        return new InternalColumnValidator(delegate){

            @Override
            protected Object internalValidate(Column col, Object val) throws IOException {
                return ColValidatorEvalContext.this.validate(val);
            }

            @Override
            protected void appendToString(StringBuilder sb) {
                sb.append("expression=").append(ColValidatorEvalContext.this);
            }
        };
    }

    private void reset() {
        this._val = null;
    }

    @Override
    public Value getThisColumnValue() {
        return this.toValue(this._val);
    }

    @Override
    public Value getIdentifierValue(Identifier identifier) {
        if (!this.getCol().isThisColumn(identifier)) {
            throw new EvalException("Cannot access other fields for " + identifier);
        }
        return this.getThisColumnValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object validate(Object val) throws IOException {
        try {
            this._val = val;
            Boolean result = (Boolean)this.eval();
            if (!result.booleanValue()) {
                Object msg = this._helpStr != null ? this._helpStr : "Invalid column value '" + val + "'";
                throw new InvalidValueException(this.withErrorContext((String)msg));
            }
            Object object = val;
            return object;
        }
        finally {
            this.reset();
        }
    }
}

