/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.innate.http;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.innate.http.SniConfigurator;
import org.glassfish.jersey.internal.PropertiesResolver;

public final class SSLParamConfigurator {
    private final URI uri;
    private final Optional<SniConfigurator> sniConfigurator;

    private SSLParamConfigurator(Builder builder) {
        Map httpHeaders = builder.clientRequest != null ? builder.clientRequest.getHeaders() : builder.httpHeaders;
        this.uri = builder.clientRequest != null ? builder.clientRequest.getUri() : builder.uri;
        this.sniConfigurator = builder.sniHostPrecedence == null ? SniConfigurator.createWhenHostHeader(this.uri, httpHeaders, builder.setAlways) : SniConfigurator.createWhenHostHeader(this.uri, builder.sniHostPrecedence, false);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getSNIHostName() {
        return this.sniConfigurator.isPresent() ? this.sniConfigurator.get().getHostName() : this.uri.getHost();
    }

    public URI toIPRequestUri() {
        String host = this.uri.getHost();
        try {
            InetAddress ip = InetAddress.getByName(host);
            return UriBuilder.fromUri((URI)this.uri).host(ip.getHostAddress()).build(new Object[0]);
        }
        catch (UnknownHostException e) {
            return this.uri;
        }
    }

    public boolean isSNIRequired() {
        return this.sniConfigurator.isPresent();
    }

    public URI getSNIUri() {
        return this.sniConfigurator.isPresent() ? UriBuilder.fromUri((URI)this.uri).host(this.getSNIHostName()).build(new Object[0]) : this.uri;
    }

    public void setSNIServerName(SSLEngine sslEngine) {
        this.sniConfigurator.ifPresent(sni -> sni.setServerNames(sslEngine));
    }

    public void setSNIServerName(SSLSocket sslSocket) {
        this.sniConfigurator.ifPresent(sni -> sni.setServerNames(sslSocket));
    }

    public void setEndpointIdentificationAlgorithm(SSLEngine sslEngine) {
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
        sslEngine.setSSLParameters(sslParameters);
    }

    public static final class Builder {
        private ClientRequest clientRequest;
        private URI uri;
        private Map<String, List<Object>> httpHeaders;
        private boolean setAlways = false;
        private String sniHostPrecedence = null;

        public Builder request(ClientRequest clientRequest) {
            this.clientRequest = clientRequest;
            this.httpHeaders = null;
            this.uri = null;
            return this;
        }

        public Builder uri(URI uri) {
            this.clientRequest = null;
            this.uri = uri;
            return this;
        }

        public Builder headers(Map<String, List<Object>> httpHeaders) {
            this.clientRequest = null;
            this.httpHeaders = httpHeaders;
            return this;
        }

        public Builder setSNIAlways(boolean setAlways) {
            this.setAlways = setAlways;
            return this;
        }

        public Builder setSNIHostName(String hostName) {
            this.sniHostPrecedence = hostName;
            return this;
        }

        public Builder setSNIHostName(Configuration configuration) {
            return this.setSNIHostName((String)configuration.getProperty("jersey.config.client.snihostname"));
        }

        public Builder setSNIHostName(PropertiesResolver resolver) {
            return this.setSNIHostName((String)resolver.resolveProperty("jersey.config.client.snihostname", String.class));
        }

        public SSLParamConfigurator build() {
            return new SSLParamConfigurator(this);
        }
    }
}

