/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.v3;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.driver.internal.messaging.AbstractMessageWriter;
import org.neo4j.driver.internal.messaging.MessageEncoder;
import org.neo4j.driver.internal.messaging.common.CommonValuePacker;
import org.neo4j.driver.internal.messaging.encode.BeginMessageEncoder;
import org.neo4j.driver.internal.messaging.encode.CommitMessageEncoder;
import org.neo4j.driver.internal.messaging.encode.DiscardAllMessageEncoder;
import org.neo4j.driver.internal.messaging.encode.GoodbyeMessageEncoder;
import org.neo4j.driver.internal.messaging.encode.HelloMessageEncoder;
import org.neo4j.driver.internal.messaging.encode.PullAllMessageEncoder;
import org.neo4j.driver.internal.messaging.encode.ResetMessageEncoder;
import org.neo4j.driver.internal.messaging.encode.RollbackMessageEncoder;
import org.neo4j.driver.internal.messaging.encode.RunWithMetadataMessageEncoder;
import org.neo4j.driver.internal.packstream.PackOutput;
import org.neo4j.driver.internal.util.Iterables;

public class MessageWriterV3
extends AbstractMessageWriter {
    public MessageWriterV3(PackOutput output) {
        super(new CommonValuePacker(output, false), MessageWriterV3.buildEncoders());
    }

    private static Map<Byte, MessageEncoder> buildEncoders() {
        HashMap<Byte, MessageEncoder> result = Iterables.newHashMapWithSize(9);
        result.put((byte)1, new HelloMessageEncoder());
        result.put((byte)2, new GoodbyeMessageEncoder());
        result.put((byte)16, new RunWithMetadataMessageEncoder());
        result.put((byte)47, new DiscardAllMessageEncoder());
        result.put((byte)63, new PullAllMessageEncoder());
        result.put((byte)17, new BeginMessageEncoder());
        result.put((byte)18, new CommitMessageEncoder());
        result.put((byte)19, new RollbackMessageEncoder());
        result.put((byte)15, new ResetMessageEncoder());
        return result;
    }
}

