/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.async.pool.ExtendedChannelPool;
import org.neo4j.driver.internal.handlers.ResetResponseHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.Futures;

public class ChannelReleasingResetResponseHandler
extends ResetResponseHandler {
    private final Channel channel;
    private final ExtendedChannelPool pool;
    private final Clock clock;

    public ChannelReleasingResetResponseHandler(Channel channel, ExtendedChannelPool pool, InboundMessageDispatcher messageDispatcher, Clock clock, CompletableFuture<Void> releaseFuture) {
        super(messageDispatcher, releaseFuture);
        this.channel = channel;
        this.pool = pool;
        this.clock = clock;
    }

    @Override
    protected void resetCompleted(CompletableFuture<Void> completionFuture, boolean success) {
        CompletionStage<Void> closureStage;
        if (success) {
            ChannelAttributes.setLastUsedTimestamp(this.channel, this.clock.millis());
            closureStage = Futures.completedWithNull();
        } else {
            closureStage = Futures.asCompletionStage(this.channel.close());
        }
        closureStage.exceptionally(throwable -> null).thenCompose(ignored -> this.pool.release(this.channel)).whenComplete((ignore, error) -> completionFuture.complete(null));
    }
}

