/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.connection;

import javax.net.ssl.SSLHandshakeException;
import org.neo4j.driver.Logging;
import org.neo4j.driver.exceptions.SecurityException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.connection.BoltProtocolUtil;
import org.neo4j.driver.internal.async.connection.ChannelPipelineBuilder;
import org.neo4j.driver.internal.async.connection.HandshakeHandler;
import org.neo4j.driver.internal.logging.ChannelActivityLogger;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFuture;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFutureListener;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPipeline;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPromise;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Future;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.GenericFutureListener;

public class ChannelConnectedListener
implements ChannelFutureListener {
    private final BoltServerAddress address;
    private final ChannelPipelineBuilder pipelineBuilder;
    private final ChannelPromise handshakeCompletedPromise;
    private final Logging logging;

    public ChannelConnectedListener(BoltServerAddress address, ChannelPipelineBuilder pipelineBuilder, ChannelPromise handshakeCompletedPromise, Logging logging) {
        this.address = address;
        this.pipelineBuilder = pipelineBuilder;
        this.handshakeCompletedPromise = handshakeCompletedPromise;
        this.logging = logging;
    }

    @Override
    public void operationComplete(ChannelFuture future) {
        Channel channel = future.channel();
        ChannelActivityLogger log = new ChannelActivityLogger(channel, this.logging, this.getClass());
        if (future.isSuccess()) {
            log.trace("Channel %s connected, initiating bolt handshake", channel);
            ChannelPipeline pipeline = channel.pipeline();
            pipeline.addLast(new HandshakeHandler(this.pipelineBuilder, this.handshakeCompletedPromise, this.logging));
            log.debug("C: [Bolt Handshake] %s", BoltProtocolUtil.handshakeString());
            channel.writeAndFlush(BoltProtocolUtil.handshakeBuf()).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
                if (!f.isSuccess()) {
                    Throwable error = f.cause();
                    error = error instanceof SSLHandshakeException ? new SecurityException("Failed to establish secured connection with the server", error) : new ServiceUnavailableException(String.format("Unable to write Bolt handshake to %s.", this.address), error);
                    this.handshakeCompletedPromise.setFailure(error);
                }
            }));
        } else {
            this.handshakeCompletedPromise.setFailure(ChannelConnectedListener.databaseUnavailableError(this.address, future.cause()));
        }
    }

    private static Throwable databaseUnavailableError(BoltServerAddress address, Throwable cause) {
        return new ServiceUnavailableException(String.format("Unable to connect to %s, ensure the database is running and that there is a working network connection to it.", address), cause);
    }
}

