/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Objects;
import org.neo4j.driver.types.Point;

public class InternalPoint2D
implements Point {
    private final int srid;
    private final double x;
    private final double y;

    public InternalPoint2D(int srid, double x, double y) {
        this.srid = srid;
        this.x = x;
        this.y = y;
    }

    @Override
    public int srid() {
        return this.srid;
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    @Override
    public double z() {
        return Double.NaN;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalPoint2D that = (InternalPoint2D)o;
        return this.srid == that.srid && Double.compare(that.x, this.x) == 0 && Double.compare(that.y, this.y) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.srid, this.x, this.y);
    }

    public String toString() {
        return "Point{srid=" + this.srid + ", x=" + this.x + ", y=" + this.y + '}';
    }
}

