/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.transfermanager;

import com.google.api.core.ApiFuture;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BlobWriteSession;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.transfermanager.ParallelUploadConfig;
import com.google.cloud.storage.transfermanager.TransferStatus;
import com.google.cloud.storage.transfermanager.UploadResult;
import com.google.common.io.ByteStreams;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class ParallelCompositeUploadCallable
implements Callable<UploadResult> {
    private final Storage storage;
    private final BlobInfo originalBlob;
    private final Path sourceFile;
    private final ParallelUploadConfig parallelUploadConfig;
    private final Storage.BlobWriteOption[] opts;

    public ParallelCompositeUploadCallable(Storage storage, BlobInfo originalBlob, Path sourceFile, ParallelUploadConfig parallelUploadConfig, Storage.BlobWriteOption[] opts) {
        this.storage = storage;
        this.originalBlob = originalBlob;
        this.sourceFile = sourceFile;
        this.parallelUploadConfig = parallelUploadConfig;
        this.opts = opts;
    }

    @Override
    public UploadResult call() {
        return this.uploadPCU();
    }

    private UploadResult uploadPCU() {
        BlobWriteSession session = this.storage.blobWriteSession(this.originalBlob, this.opts);
        try (WritableByteChannel writableByteChannel = session.open();
             FileChannel fc = FileChannel.open(this.sourceFile, StandardOpenOption.READ);){
            ByteStreams.copy((ReadableByteChannel)fc, (WritableByteChannel)writableByteChannel);
        }
        catch (StorageException e) {
            if (this.parallelUploadConfig.isSkipIfExists() && e.getCode() == 412) {
                return UploadResult.newBuilder(this.originalBlob, TransferStatus.SKIPPED).setException((Exception)((Object)e)).build();
            }
            return UploadResult.newBuilder(this.originalBlob, TransferStatus.FAILED_TO_FINISH).setException((Exception)((Object)e)).build();
        }
        catch (Exception e) {
            return UploadResult.newBuilder(this.originalBlob, TransferStatus.FAILED_TO_FINISH).setException(e).build();
        }
        try {
            ApiFuture<BlobInfo> result = session.getResult();
            BlobInfo newBlob = (BlobInfo)result.get(10L, TimeUnit.SECONDS);
            return UploadResult.newBuilder(this.originalBlob, TransferStatus.SUCCESS).setUploadedBlob(newBlob).build();
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return UploadResult.newBuilder(this.originalBlob, TransferStatus.FAILED_TO_FINISH).setException(e).build();
        }
    }
}

