/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.gax.rpc.HeaderProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;

final class XGoogApiClientHeaderProvider
implements HeaderProvider {
    private static final Collector<CharSequence, ?, String> COMBINER = Collectors.joining(" ");
    private final Map<String, String> headers;

    private XGoogApiClientHeaderProvider(Map<String, String> headers) {
        this.headers = headers;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    static XGoogApiClientHeaderProvider of(HeaderProvider baseValue, ImmutableList<String> additionalEntries) {
        if (additionalEntries.isEmpty()) {
            return new XGoogApiClientHeaderProvider(baseValue.getHeaders());
        }
        ImmutableMap right = ImmutableMap.of((Object)"x-goog-api-client", (Object)additionalEntries.stream().collect(COMBINER));
        ImmutableMap<String, String> union = XGoogApiClientHeaderProvider.union(baseValue.getHeaders(), (Map<String, String>)right);
        return new XGoogApiClientHeaderProvider((Map<String, String>)union);
    }

    @VisibleForTesting
    static ImmutableMap<String, String> union(Map<String, String> left, Map<String, String> right) {
        Map<String, String> r;
        if (left.equals(right)) {
            return ImmutableMap.copyOf(left);
        }
        Map<String, String> l = XGoogApiClientHeaderProvider.lowerKeys(left);
        if (l.equals(r = XGoogApiClientHeaderProvider.lowerKeys(right))) {
            return ImmutableMap.copyOf(l);
        }
        HashMap<String, String> tmp = new HashMap<String, String>();
        MapDifference diff = Maps.difference(l, r);
        tmp.putAll(diff.entriesOnlyOnLeft());
        tmp.putAll(diff.entriesOnlyOnRight());
        tmp.putAll(diff.entriesInCommon());
        for (Map.Entry e : diff.entriesDiffering().entrySet()) {
            String k = (String)e.getKey();
            MapDifference.ValueDifference v = (MapDifference.ValueDifference)e.getValue();
            tmp.put(k, ImmutableList.of((Object)((String)v.leftValue()), (Object)((String)v.rightValue())).stream().collect(COMBINER));
        }
        return ImmutableMap.copyOf(tmp);
    }

    private static Map<String, String> lowerKeys(Map<String, String> orig) {
        HashMap<String, String> tmp = new HashMap<String, String>();
        for (Map.Entry<String, String> e : orig.entrySet()) {
            String k = e.getKey();
            String v = e.getValue();
            tmp.put(k.toLowerCase(Locale.US), v);
        }
        return tmp;
    }
}

