/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio.testing;

public abstract class TestConfiguration {
    public static final String GCS_TEST_PROJECT_ID = "GCS_TEST_PROJECT_ID";
    public static final String GCS_TEST_SERVICE_ACCOUNT = "GCS_TEST_SERVICE_ACCOUNT";
    public static final String GCS_TEST_PRIVATE_KEYFILE = "GCS_TEST_PRIVATE_KEYFILE";
    public static final String GCS_TEST_JSON_KEYFILE = "GCS_TEST_JSON_KEYFILE";
    public static final String TRAFFIC_DIRECTOR_ENABLED = "TRAFFIC_DIRECTOR_ENABLED";
    public static final String GCS_TEST_DIRECT_PATH_PREFERRED = "GCS_TEST_DIRECT_PATH_PREFERRED";

    public static TestConfiguration getInstance() {
        return LazyHolder.INSTANCE;
    }

    public abstract String getProjectId();

    public abstract String getServiceAccount();

    public abstract String getPrivateKeyFile();

    public abstract String getServiceAccountJsonKeyFile();

    public abstract boolean isTrafficDirector();

    public abstract boolean isDirectPathPreferred();

    private static class LazyHolder {
        private static final TestConfiguration INSTANCE = new EnvironmentBasedTestConfiguration();

        private LazyHolder() {
        }
    }

    public static class EnvironmentBasedTestConfiguration
    extends TestConfiguration {
        @Override
        public String getProjectId() {
            return System.getenv(TestConfiguration.GCS_TEST_PROJECT_ID);
        }

        @Override
        public String getServiceAccount() {
            return System.getenv(TestConfiguration.GCS_TEST_SERVICE_ACCOUNT);
        }

        @Override
        public String getPrivateKeyFile() {
            return System.getenv(TestConfiguration.GCS_TEST_PRIVATE_KEYFILE);
        }

        @Override
        public String getServiceAccountJsonKeyFile() {
            return System.getenv(TestConfiguration.GCS_TEST_JSON_KEYFILE);
        }

        @Override
        public boolean isTrafficDirector() {
            String td = System.getenv(TestConfiguration.TRAFFIC_DIRECTOR_ENABLED);
            return td == null || !td.equalsIgnoreCase("false");
        }

        @Override
        public boolean isDirectPathPreferred() {
            String envVar = System.getenv(TestConfiguration.GCS_TEST_DIRECT_PATH_PREFERRED);
            if (envVar == null) {
                return true;
            }
            return Boolean.parseBoolean(envVar);
        }
    }
}

