/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio.authorization;

import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.StorageRequest;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.ComposeRequest;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.gcsio.UriPaths;
import com.google.cloud.hadoop.gcsio.authorization.AuthorizationHandler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import java.net.URI;
import java.nio.file.AccessDeniedException;
import java.util.List;
import java.util.Map;

public class StorageRequestAuthorizer {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final AuthorizationHandler authorizationHandler;

    public StorageRequestAuthorizer(Class<? extends AuthorizationHandler> handlerClass, Map<String, String> properties) {
        Preconditions.checkNotNull(handlerClass, (Object)"handlerClass can not be null");
        Preconditions.checkNotNull(properties, (Object)"properties can not be null");
        try {
            this.authorizationHandler = handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Can not instantiate authorization handler.", e);
        }
        this.authorizationHandler.setProperties(properties);
    }

    @VisibleForTesting
    StorageRequestAuthorizer(AuthorizationHandler authorizationHandler) {
        this.authorizationHandler = (AuthorizationHandler)Preconditions.checkNotNull((Object)authorizationHandler, (Object)"authorizationHandler can not be null");
    }

    public void authorize(StorageRequest<?> request) throws AccessDeniedException {
        ((GoogleLogger.Api)logger.atFiner()).log("authorizeStorageRequest(%s)", request);
        if (request instanceof Storage.Objects.List) {
            Storage.Objects.List listRequest = (Storage.Objects.List)request;
            this.authorizationHandler.handleListObjects(StorageRequestAuthorizer.getGcsUri(listRequest.getBucket(), listRequest.getPrefix()));
        } else if (request instanceof Storage.Objects.Insert) {
            Storage.Objects.Insert insertRequest = (Storage.Objects.Insert)request;
            this.authorizationHandler.handleInsertObject(StorageRequestAuthorizer.getGcsUri(insertRequest.getBucket(), ((StorageObject)StorageRequestAuthorizer.getData(request)).getName()));
        } else if (request instanceof Storage.Objects.Compose) {
            Storage.Objects.Compose composeRequest = (Storage.Objects.Compose)request;
            String bucket = composeRequest.getDestinationBucket();
            URI destination = StorageRequestAuthorizer.getGcsUri(bucket, composeRequest.getDestinationObject());
            List sources = (List)((ComposeRequest)StorageRequestAuthorizer.getData(request)).getSourceObjects().stream().map(source -> StorageRequestAuthorizer.getGcsUri(bucket, source.getName())).collect(ImmutableList.toImmutableList());
            this.authorizationHandler.handleComposeObject(destination, sources);
        } else if (request instanceof Storage.Objects.Get) {
            Storage.Objects.Get getRequest = (Storage.Objects.Get)request;
            this.authorizationHandler.handleGetObject(StorageRequestAuthorizer.getGcsUri(getRequest.getBucket(), getRequest.getObject()));
        } else if (request instanceof Storage.Objects.Delete) {
            Storage.Objects.Delete deleteRequest = (Storage.Objects.Delete)request;
            this.authorizationHandler.handleDeleteObject(StorageRequestAuthorizer.getGcsUri(deleteRequest.getBucket(), deleteRequest.getObject()));
        } else if (request instanceof Storage.Objects.Rewrite) {
            Storage.Objects.Rewrite rewriteRequest = (Storage.Objects.Rewrite)request;
            this.authorizationHandler.handleRewriteObject(StorageRequestAuthorizer.getGcsUri(rewriteRequest.getSourceBucket(), rewriteRequest.getSourceObject()), StorageRequestAuthorizer.getGcsUri(rewriteRequest.getDestinationBucket(), rewriteRequest.getDestinationObject()));
        } else if (request instanceof Storage.Objects.Copy) {
            Storage.Objects.Copy copyRequest = (Storage.Objects.Copy)request;
            this.authorizationHandler.handleCopyObject(StorageRequestAuthorizer.getGcsUri(copyRequest.getSourceBucket(), copyRequest.getSourceObject()), StorageRequestAuthorizer.getGcsUri(copyRequest.getDestinationBucket(), copyRequest.getDestinationObject()));
        } else if (request instanceof Storage.Objects.Patch) {
            Storage.Objects.Patch patchRequest = (Storage.Objects.Patch)request;
            this.authorizationHandler.handlePatchObject(StorageRequestAuthorizer.getGcsUri(patchRequest.getBucket(), patchRequest.getObject()));
        } else if (request instanceof Storage.Buckets.List) {
            this.authorizationHandler.handleListBuckets(((Storage.Buckets.List)request).getProject());
        } else if (request instanceof Storage.Buckets.Insert) {
            this.authorizationHandler.handleInsertBucket(((Storage.Buckets.Insert)request).getProject(), StorageRequestAuthorizer.getGcsUri(((Bucket)StorageRequestAuthorizer.getData(request)).getName(), null));
        } else if (request instanceof Storage.Buckets.Get) {
            this.authorizationHandler.handleGetBucket(StorageRequestAuthorizer.getGcsUri(((Storage.Buckets.Get)request).getBucket(), null));
        } else if (request instanceof Storage.Buckets.Delete) {
            this.authorizationHandler.handleDeleteBucket(StorageRequestAuthorizer.getGcsUri(((Storage.Buckets.Delete)request).getBucket(), null));
        } else {
            throw new RuntimeException("Unhandled storage request type. Request: " + request);
        }
    }

    private static Object getData(StorageRequest<?> request) {
        return ((JsonHttpContent)request.getHttpContent()).getData();
    }

    private static URI getGcsUri(String bucketName, String objectPath) {
        return UriPaths.fromStringPathComponents(bucketName, objectPath, true);
    }
}

