/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal4j;

import com.microsoft.aad.adal4j.DeviceCode;
import com.microsoft.aad.adal4j.HttpHelper;
import com.microsoft.aad.adal4j.JsonHelper;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.net.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceCodeRequest {
    private static final Logger log = LoggerFactory.getLogger(DeviceCodeRequest.class);

    static DeviceCode execute(String url, String clientId, String resource, Map<String, String> clientDataHeaders, Proxy proxy, SSLSocketFactory sslSocketFactory) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>(clientDataHeaders);
        headers.put("Accept", "application/json");
        HashMap<String, List<String>> queryParameters = new HashMap<String, List<String>>();
        queryParameters.put("client_id", Collections.singletonList(clientId));
        queryParameters.put("resource", Collections.singletonList(resource));
        url = url + "?" + URLUtils.serializeParameters(queryParameters);
        String json = HttpHelper.executeHttpGet(log, url, headers, proxy, sslSocketFactory);
        DeviceCode result = JsonHelper.convertJsonToObject(json, DeviceCode.class);
        result.setCorrelationId((String)headers.get("client-request-id"));
        result.setClientId(clientId);
        result.setResource(resource);
        return result;
    }
}

