/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal4j;

import com.microsoft.aad.adal4j.AcquireDeviceCodeCallable;
import com.microsoft.aad.adal4j.AcquireTokenCallable;
import com.microsoft.aad.adal4j.AdalAuthorizationGrant;
import com.microsoft.aad.adal4j.AdalDeviceCodeAuthorizationGrant;
import com.microsoft.aad.adal4j.AdalIntegratedAuthorizationGrant;
import com.microsoft.aad.adal4j.AdalOAuthAuthorizationGrant;
import com.microsoft.aad.adal4j.AdalTokenRequest;
import com.microsoft.aad.adal4j.AsymmetricKeyCredential;
import com.microsoft.aad.adal4j.AuthenticationAuthority;
import com.microsoft.aad.adal4j.AuthenticationCallback;
import com.microsoft.aad.adal4j.AuthenticationException;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.AuthorityType;
import com.microsoft.aad.adal4j.ClientAssertion;
import com.microsoft.aad.adal4j.ClientAuthenticationPost;
import com.microsoft.aad.adal4j.ClientCredential;
import com.microsoft.aad.adal4j.ClientDataHttpHeaders;
import com.microsoft.aad.adal4j.DeviceCode;
import com.microsoft.aad.adal4j.JwtHelper;
import com.microsoft.aad.adal4j.LogHelper;
import com.microsoft.aad.adal4j.StringHelper;
import com.microsoft.aad.adal4j.UserAssertion;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ClientCredentialsGrant;
import com.nimbusds.oauth2.sdk.JWTBearerGrant;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.ResourceOwnerPasswordCredentialsGrant;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import com.nimbusds.oauth2.sdk.auth.PrivateKeyJWT;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationContext {
    final Logger log = LoggerFactory.getLogger(AuthenticationContext.class);
    final AuthenticationAuthority authenticationAuthority;
    String correlationId;
    private String authority;
    private final ExecutorService service;
    private final boolean validateAuthority;
    Proxy proxy;
    SSLSocketFactory sslSocketFactory;
    private boolean logPii = false;

    public boolean isLogPii() {
        return this.logPii;
    }

    public void setLogPii(boolean logPii) {
        this.logPii = logPii;
    }

    public AuthenticationContext(String authority, boolean validateAuthority, ExecutorService service) throws MalformedURLException {
        if (StringHelper.isBlank(authority)) {
            throw new IllegalArgumentException("authority is null or empty");
        }
        if (service == null) {
            throw new IllegalArgumentException("service is null");
        }
        this.service = service;
        this.validateAuthority = validateAuthority;
        this.authority = this.canonicalizeUri(authority);
        this.authenticationAuthority = new AuthenticationAuthority(new URL(this.getAuthority()), this.shouldValidateAuthority());
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    private String canonicalizeUri(String authority) {
        if (!authority.endsWith("/")) {
            authority = authority + "/";
        }
        return authority;
    }

    public Future<AuthenticationResult> acquireToken(String resource, String clientId, String username, String password, AuthenticationCallback callback) {
        if (StringHelper.isBlank(resource)) {
            throw new IllegalArgumentException("resource is null or empty");
        }
        if (StringHelper.isBlank(clientId)) {
            throw new IllegalArgumentException("clientId is null or empty");
        }
        if (StringHelper.isBlank(username)) {
            throw new IllegalArgumentException("username is null or empty");
        }
        ClientAuthenticationPost clientAuth = new ClientAuthenticationPost(ClientAuthenticationMethod.NONE, new ClientID(clientId));
        if (password != null) {
            return this.acquireToken(new AdalOAuthAuthorizationGrant((AuthorizationGrant)new ResourceOwnerPasswordCredentialsGrant(username, new Secret(password)), resource), clientAuth, (AuthenticationCallback<AuthenticationResult>)callback);
        }
        return this.acquireToken(new AdalIntegratedAuthorizationGrant(username, resource), clientAuth, (AuthenticationCallback<AuthenticationResult>)callback);
    }

    public Future<AuthenticationResult> acquireToken(String resource, ClientAssertion clientAssertion, AuthenticationCallback callback) {
        this.validateInput(resource, clientAssertion, true);
        ClientAuthentication clientAuth = this.createClientAuthFromClientAssertion(clientAssertion);
        AdalOAuthAuthorizationGrant authGrant = new AdalOAuthAuthorizationGrant((AuthorizationGrant)new ClientCredentialsGrant(), resource);
        return this.acquireToken(authGrant, clientAuth, (AuthenticationCallback<AuthenticationResult>)callback);
    }

    public Future<AuthenticationResult> acquireToken(String resource, UserAssertion userAssertion, ClientCredential credential, AuthenticationCallback callback) {
        this.validateOnBehalfOfRequestInput(resource, userAssertion, credential, true);
        ClientSecretPost clientAuth = new ClientSecretPost(new ClientID(credential.getClientId()), new Secret(credential.getClientSecret()));
        return this.acquireTokenOnBehalfOf(resource, userAssertion, (ClientAuthentication)clientAuth, callback);
    }

    public Future<AuthenticationResult> acquireToken(String resource, UserAssertion userAssertion, AsymmetricKeyCredential credential, AuthenticationCallback callback) {
        this.validateOnBehalfOfRequestInput(resource, userAssertion, credential, true);
        ClientAssertion clientAssertion = JwtHelper.buildJwt(credential, this.authenticationAuthority.getSelfSignedJwtAudience());
        ClientAuthentication clientAuth = this.createClientAuthFromClientAssertion(clientAssertion);
        return this.acquireTokenOnBehalfOf(resource, userAssertion, clientAuth, callback);
    }

    private Future<AuthenticationResult> acquireTokenOnBehalfOf(String resource, UserAssertion userAssertion, ClientAuthentication clientAuthentication, AuthenticationCallback callback) {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("resource", Collections.singletonList(resource));
        params.put("requested_token_use", Collections.singletonList("on_behalf_of"));
        try {
            AdalOAuthAuthorizationGrant grant = new AdalOAuthAuthorizationGrant((AuthorizationGrant)new JWTBearerGrant(SignedJWT.parse((String)userAssertion.getAssertion())), params);
            return this.acquireToken(grant, clientAuthentication, (AuthenticationCallback<AuthenticationResult>)callback);
        }
        catch (Exception e) {
            throw new AuthenticationException(e);
        }
    }

    public Future<AuthenticationResult> acquireToken(String resource, ClientCredential credential, AuthenticationCallback callback) {
        this.validateInput(resource, credential, true);
        ClientSecretPost clientAuth = new ClientSecretPost(new ClientID(credential.getClientId()), new Secret(credential.getClientSecret()));
        AdalOAuthAuthorizationGrant authGrant = new AdalOAuthAuthorizationGrant((AuthorizationGrant)new ClientCredentialsGrant(), resource);
        return this.acquireToken(authGrant, (ClientAuthentication)clientAuth, (AuthenticationCallback<AuthenticationResult>)callback);
    }

    public Future<AuthenticationResult> acquireToken(String resource, AsymmetricKeyCredential credential, AuthenticationCallback callback) throws AuthenticationException {
        return this.acquireToken(resource, JwtHelper.buildJwt(credential, this.authenticationAuthority.getSelfSignedJwtAudience()), callback);
    }

    public Future<AuthenticationResult> acquireTokenByAuthorizationCode(String authorizationCode, String resource, String clientId, URI redirectUri, AuthenticationCallback callback) {
        ClientAuthenticationPost clientAuth = new ClientAuthenticationPost(ClientAuthenticationMethod.NONE, new ClientID(clientId));
        this.validateAuthCodeRequestInput(authorizationCode, redirectUri, (Object)clientAuth, resource);
        AdalOAuthAuthorizationGrant authGrant = new AdalOAuthAuthorizationGrant((AuthorizationGrant)new AuthorizationCodeGrant(new AuthorizationCode(authorizationCode), redirectUri), resource);
        return this.acquireToken(authGrant, clientAuth, (AuthenticationCallback<AuthenticationResult>)callback);
    }

    public Future<AuthenticationResult> acquireTokenByAuthorizationCode(String authorizationCode, URI redirectUri, ClientAssertion clientAssertion, AuthenticationCallback callback) {
        return this.acquireTokenByAuthorizationCode(authorizationCode, redirectUri, clientAssertion, (String)null, callback);
    }

    public Future<AuthenticationResult> acquireTokenByAuthorizationCode(String authorizationCode, URI redirectUri, ClientAssertion clientAssertion, String resource, AuthenticationCallback callback) {
        this.validateAuthCodeRequestInput(authorizationCode, redirectUri, clientAssertion, resource);
        ClientAuthentication clientAuth = this.createClientAuthFromClientAssertion(clientAssertion);
        AdalOAuthAuthorizationGrant authGrant = new AdalOAuthAuthorizationGrant((AuthorizationGrant)new AuthorizationCodeGrant(new AuthorizationCode(authorizationCode), redirectUri), resource);
        return this.acquireToken(authGrant, clientAuth, (AuthenticationCallback<AuthenticationResult>)callback);
    }

    public Future<AuthenticationResult> acquireTokenByAuthorizationCode(String authorizationCode, URI redirectUri, ClientCredential credential, AuthenticationCallback callback) {
        this.validateAuthCodeRequestInput(authorizationCode, redirectUri, credential, null);
        return this.acquireTokenByAuthorizationCode(authorizationCode, redirectUri, credential, null, callback);
    }

    public Future<AuthenticationResult> acquireTokenByAuthorizationCode(String authorizationCode, URI redirectUri, ClientCredential credential, String resource, AuthenticationCallback callback) {
        this.validateAuthCodeRequestInput(authorizationCode, redirectUri, credential, resource);
        ClientSecretPost clientAuth = new ClientSecretPost(new ClientID(credential.getClientId()), new Secret(credential.getClientSecret()));
        AdalOAuthAuthorizationGrant authGrant = new AdalOAuthAuthorizationGrant((AuthorizationGrant)new AuthorizationCodeGrant(new AuthorizationCode(authorizationCode), redirectUri), resource);
        return this.acquireToken(authGrant, (ClientAuthentication)clientAuth, (AuthenticationCallback<AuthenticationResult>)callback);
    }

    public Future<AuthenticationResult> acquireTokenByAuthorizationCode(String authorizationCode, URI redirectUri, AsymmetricKeyCredential credential, AuthenticationCallback callback) throws AuthenticationException {
        return this.acquireTokenByAuthorizationCode(authorizationCode, redirectUri, credential, null, callback);
    }

    public Future<AuthenticationResult> acquireTokenByAuthorizationCode(String authorizationCode, URI redirectUri, AsymmetricKeyCredential credential, String resource, AuthenticationCallback callback) throws AuthenticationException {
        this.validateAuthCodeRequestInput(authorizationCode, redirectUri, credential, resource);
        return this.acquireTokenByAuthorizationCode(authorizationCode, redirectUri, JwtHelper.buildJwt(credential, this.authenticationAuthority.getSelfSignedJwtAudience()), resource, callback);
    }

    public Future<DeviceCode> acquireDeviceCode(String clientId, String resource, AuthenticationCallback<DeviceCode> callback) {
        this.validateDeviceCodeRequestInput(clientId, resource);
        return this.service.submit(new AcquireDeviceCodeCallable(this, clientId, resource, callback));
    }

    public Future<AuthenticationResult> acquireTokenByDeviceCode(DeviceCode deviceCode, AuthenticationCallback callback) throws AuthenticationException {
        ClientAuthenticationPost clientAuth = new ClientAuthenticationPost(ClientAuthenticationMethod.NONE, new ClientID(deviceCode.getClientId()));
        this.validateDeviceCodeRequestInput(deviceCode, (Object)clientAuth, deviceCode.getResource());
        AdalDeviceCodeAuthorizationGrant deviceCodeGrant = new AdalDeviceCodeAuthorizationGrant(deviceCode, deviceCode.getResource());
        return this.acquireToken(deviceCodeGrant, clientAuth, (AuthenticationCallback<AuthenticationResult>)callback);
    }

    public Future<AuthenticationResult> acquireTokenByRefreshToken(String refreshToken, String clientId, ClientAssertion clientAssertion, AuthenticationCallback callback) {
        return this.acquireTokenByRefreshToken(refreshToken, clientId, clientAssertion, null, callback);
    }

    public Future<AuthenticationResult> acquireTokenByRefreshToken(String refreshToken, String clientId, ClientAssertion clientAssertion, String resource, AuthenticationCallback callback) {
        this.validateRefreshTokenRequestInput(refreshToken, clientId, clientAssertion);
        ClientAuthentication clientAuth = this.createClientAuthFromClientAssertion(clientAssertion);
        AdalOAuthAuthorizationGrant authGrant = new AdalOAuthAuthorizationGrant((AuthorizationGrant)new RefreshTokenGrant(new RefreshToken(refreshToken)), resource);
        return this.acquireToken(authGrant, clientAuth, (AuthenticationCallback<AuthenticationResult>)callback);
    }

    public Future<AuthenticationResult> acquireTokenByRefreshToken(String refreshToken, ClientCredential credential, AuthenticationCallback callback) {
        return this.acquireTokenByRefreshToken(refreshToken, credential, (String)null, callback);
    }

    public Future<AuthenticationResult> acquireTokenByRefreshToken(String refreshToken, ClientCredential credential, String resource, AuthenticationCallback callback) {
        ClientSecretPost clientAuth = new ClientSecretPost(new ClientID(credential.getClientId()), new Secret(credential.getClientSecret()));
        AdalOAuthAuthorizationGrant authGrant = new AdalOAuthAuthorizationGrant((AuthorizationGrant)new RefreshTokenGrant(new RefreshToken(refreshToken)), resource);
        return this.acquireToken(authGrant, (ClientAuthentication)clientAuth, (AuthenticationCallback<AuthenticationResult>)callback);
    }

    public Future<AuthenticationResult> acquireTokenByRefreshToken(String refreshToken, AsymmetricKeyCredential credential, AuthenticationCallback callback) throws AuthenticationException {
        return this.acquireTokenByRefreshToken(refreshToken, credential, (String)null, callback);
    }

    public Future<AuthenticationResult> acquireTokenByRefreshToken(String refreshToken, AsymmetricKeyCredential credential, String resource, AuthenticationCallback callback) throws AuthenticationException {
        return this.acquireTokenByRefreshToken(refreshToken, credential.getClientId(), JwtHelper.buildJwt(credential, this.authenticationAuthority.getSelfSignedJwtAudience()), resource, callback);
    }

    public Future<AuthenticationResult> acquireTokenByRefreshToken(String refreshToken, String clientId, AuthenticationCallback callback) {
        return this.acquireTokenByRefreshToken(refreshToken, clientId, (String)null, callback);
    }

    private Future<AuthenticationResult> acquireToken(AdalAuthorizationGrant authGrant, ClientAuthentication clientAuth, AuthenticationCallback<AuthenticationResult> callback) {
        return this.service.submit(new AcquireTokenCallable(this, authGrant, clientAuth, callback));
    }

    public Future<AuthenticationResult> acquireTokenByRefreshToken(String refreshToken, String clientId, String resource, AuthenticationCallback callback) {
        ClientAuthenticationPost clientAuth = new ClientAuthenticationPost(ClientAuthenticationMethod.NONE, new ClientID(clientId));
        AdalOAuthAuthorizationGrant authGrant = new AdalOAuthAuthorizationGrant((AuthorizationGrant)new RefreshTokenGrant(new RefreshToken(refreshToken)), resource);
        return this.acquireToken(authGrant, clientAuth, (AuthenticationCallback<AuthenticationResult>)callback);
    }

    private void validateRefreshTokenRequestInput(String refreshToken, String clientId, Object credential) {
        if (StringHelper.isBlank(refreshToken)) {
            throw new IllegalArgumentException("refreshToken is null or empty");
        }
        if (StringHelper.isBlank(clientId)) {
            throw new IllegalArgumentException("clientId is null or empty");
        }
        this.validateInput(null, credential, false);
    }

    AuthenticationResult acquireTokenCommon(AdalAuthorizationGrant authGrant, ClientAuthentication clientAuth, ClientDataHttpHeaders headers) throws Exception {
        if (this.logPii) {
            this.log.debug(LogHelper.createMessage(String.format("Using Client Http Headers: %s", headers), headers.getHeaderCorrelationIdValue()));
        }
        this.authenticationAuthority.doInstanceDiscovery(headers.getReadonlyHeaderMap(), this.proxy, this.sslSocketFactory);
        URL url = new URL(this.authenticationAuthority.getTokenUri());
        AdalTokenRequest request = new AdalTokenRequest(url, clientAuth, authGrant, headers.getReadonlyHeaderMap(), this.proxy, this.sslSocketFactory);
        AuthenticationResult result = request.executeOAuthRequestAndProcessResponse();
        return result;
    }

    private ClientAuthentication createClientAuthFromClientAssertion(ClientAssertion clientAssertion) {
        try {
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            map.put("client_assertion_type", Collections.singletonList(clientAssertion.getAssertionType()));
            map.put("client_assertion", Collections.singletonList(clientAssertion.getAssertion()));
            return PrivateKeyJWT.parse(map);
        }
        catch (ParseException e) {
            throw new AuthenticationException(e);
        }
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public boolean shouldValidateAuthority() {
        return this.validateAuthority;
    }

    public String getAuthority() {
        return this.authority;
    }

    private void validateInput(String resource, Object credential, boolean validateResource) {
        if (validateResource && StringHelper.isBlank(resource)) {
            throw new IllegalArgumentException("resource is null or empty");
        }
        if (credential == null) {
            throw new IllegalArgumentException("credential is null");
        }
    }

    private void validateAuthCodeRequestInput(String authorizationCode, URI redirectUri, Object clientCredential, String resource) {
        if (StringHelper.isBlank(authorizationCode)) {
            throw new IllegalArgumentException("authorization code is null or empty");
        }
        if (redirectUri == null) {
            throw new IllegalArgumentException("redirect uri is null");
        }
        this.validateInput(resource, clientCredential, false);
    }

    private void validateDeviceCodeRequestInput(String clientId, String resource) {
        if (StringHelper.isBlank(clientId)) {
            throw new IllegalArgumentException("clientId is null or empty");
        }
        if (StringHelper.isBlank(resource)) {
            throw new IllegalArgumentException("resource is null or empty");
        }
        if (AuthorityType.ADFS.equals((Object)this.authenticationAuthority.getAuthorityType())) {
            throw new IllegalArgumentException("Invalid authority type. Device Flow is not supported by ADFS authority");
        }
    }

    private void validateDeviceCodeRequestInput(DeviceCode deviceCode, Object credential, String resource) {
        if (StringHelper.isBlank(deviceCode.getDeviceCode())) {
            throw new IllegalArgumentException("device code is null or empty");
        }
        if (StringHelper.isBlank(deviceCode.getCorrelationId())) {
            throw new IllegalArgumentException("correlation id in device code is null or empty");
        }
        this.validateInput(resource, credential, true);
    }

    private void validateOnBehalfOfRequestInput(String resource, UserAssertion userAssertion, Object clientCredential, boolean validateResource) {
        if (userAssertion == null) {
            throw new IllegalArgumentException("userAssertion is null");
        }
        this.validateInput(resource, clientCredential, validateResource);
    }
}

