/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.util.LinkedList;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.util.SchedulerTask;
import org.snmp4j.util.ThreadPool;

public class TaskScheduler
implements Runnable {
    private LogAdapter logger = LogFactory.getLogger(TaskScheduler.class);
    private static final long DEFAULT_SCHEDULER_TIMEOUT = 5L;
    private LinkedList tasks = new LinkedList();
    private ThreadPool threadPool;
    private boolean stop;
    protected long schedulerTimeout = 5L;

    public TaskScheduler(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public synchronized void addTask(SchedulerTask schedulerTask) {
        this.tasks.addLast(schedulerTask);
        this.notify();
    }

    public synchronized boolean removeTask(SchedulerTask schedulerTask) {
        return this.tasks.remove(schedulerTask);
    }

    public synchronized void clear() {
        this.tasks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.stop) {
            boolean bl = false;
            Object object = this;
            synchronized (object) {
                for (int i = 0; i < this.tasks.size(); ++i) {
                    SchedulerTask schedulerTask = (SchedulerTask)this.tasks.get(i);
                    if (schedulerTask.isDone()) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Task '" + schedulerTask + "' is done");
                        }
                        this.tasks.removeFirst();
                        continue;
                    }
                    if (!schedulerTask.isReadyToRun()) continue;
                    bl = true;
                    while (!this.threadPool.tryToExecute(schedulerTask)) {
                        try {
                            ThreadPool threadPool = this.threadPool;
                            synchronized (threadPool) {
                                this.threadPool.wait(this.schedulerTimeout);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            this.logger.warn("Scheduler interrupted, aborting...");
                            this.stop = true;
                            break;
                        }
                    }
                    this.tasks.addLast(this.tasks.removeFirst());
                    --i;
                }
            }
            if (bl) continue;
            try {
                if (this.threadPool.isIdle()) {
                    object = this;
                    synchronized (object) {
                        this.wait(this.schedulerTimeout);
                        continue;
                    }
                }
                object = this.threadPool;
                synchronized (object) {
                    this.threadPool.wait(this.schedulerTimeout);
                }
            }
            catch (InterruptedException interruptedException) {
                this.logger.warn("Scheduler interrupted, aborting...");
                this.stop = true;
            }
        }
        this.logger.info("Scheduler stopped.");
    }

    public void setStop(boolean bl) {
        this.stop = bl;
    }

    public boolean isStop() {
        return this.stop;
    }
}

