/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.heif;

import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.heif.HeifDirectory;

public class HeifDescriptor
extends TagDescriptor<HeifDirectory> {
    public HeifDescriptor(HeifDirectory directory) {
        super(directory);
    }

    @Override
    public String getDescription(int tagType) {
        switch (tagType) {
            case 4: 
            case 5: {
                return this.getPixelDescription(tagType);
            }
            case 6: {
                return this.getRotationDescription();
            }
        }
        return super.getDescription(tagType);
    }

    public String getPixelDescription(int tagType) {
        return ((HeifDirectory)this._directory).getString(tagType) + " pixels";
    }

    @Nullable
    public String getRotationDescription() {
        Integer value = ((HeifDirectory)this._directory).getInteger(6);
        if (value == null) {
            return null;
        }
        return value * 90 + " degrees";
    }
}

