/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.avi;

import com.drew.imaging.riff.RiffHandler;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.avi.AviDirectory;
import java.io.IOException;

public class AviRiffHandler
implements RiffHandler {
    @NotNull
    private final AviDirectory _directory = new AviDirectory();

    public AviRiffHandler(@NotNull Metadata metadata) {
        metadata.addDirectory(this._directory);
    }

    @Override
    public boolean shouldAcceptRiffIdentifier(@NotNull String identifier) {
        return identifier.equals("AVI ");
    }

    @Override
    public boolean shouldAcceptChunk(@NotNull String fourCC) {
        return fourCC.equals("strh") || fourCC.equals("avih") || fourCC.equals("IDIT");
    }

    @Override
    public boolean shouldAcceptList(@NotNull String fourCC) {
        return fourCC.equals("hdrl") || fourCC.equals("strl") || fourCC.equals("AVI ");
    }

    @Override
    public void processChunk(@NotNull String fourCC, @NotNull byte[] payload) {
        try {
            if (fourCC.equals("strh")) {
                ByteArrayReader reader = new ByteArrayReader(payload);
                reader.setMotorolaByteOrder(false);
                String fccType = new String(reader.getBytes(0, 4));
                String fccHandler = new String(reader.getBytes(4, 4));
                float dwScale = reader.getFloat32(20);
                float dwRate = reader.getFloat32(24);
                int dwLength = reader.getInt32(32);
                if (fccType.equals("vids")) {
                    if (!this._directory.containsTag(1)) {
                        this._directory.setDouble(1, dwRate / dwScale);
                        double duration = (float)dwLength / (dwRate / dwScale);
                        int hours = (int)duration / (int)Math.pow(60.0, 2.0);
                        int minutes = (int)duration / (int)Math.pow(60.0, 1.0) - hours * 60;
                        int seconds = (int)Math.round(duration / Math.pow(60.0, 0.0) - (double)(minutes * 60));
                        String time = String.format("%1$02d:%2$02d:%3$02d", hours, minutes, seconds);
                        this._directory.setString(3, time);
                        this._directory.setString(4, fccHandler);
                    }
                } else if (fccType.equals("auds") && !this._directory.containsTag(2)) {
                    this._directory.setDouble(2, dwRate / dwScale);
                }
            } else if (fourCC.equals("avih")) {
                ByteArrayReader reader = new ByteArrayReader(payload);
                reader.setMotorolaByteOrder(false);
                int dwStreams = reader.getInt32(24);
                int dwWidth = reader.getInt32(32);
                int dwHeight = reader.getInt32(36);
                this._directory.setInt(6, dwWidth);
                this._directory.setInt(7, dwHeight);
                this._directory.setInt(8, dwStreams);
            } else if (fourCC.equals("IDIT")) {
                ByteArrayReader reader = new ByteArrayReader(payload);
                String str = reader.getString(0, payload.length, "ASCII");
                if (str.length() == 26 && str.endsWith(String.valueOf(new char[]{'\n', '\u0000'}))) {
                    str = str.substring(0, 24);
                }
                this._directory.setString(320, str);
            }
        }
        catch (IOException ex) {
            this._directory.addError(ex.getMessage());
        }
    }

    @Override
    public void addError(@NotNull String message) {
        this._directory.addError(message);
    }
}

