/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.stream;

import java.io.Serializable;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelNode;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalDataStreamScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalGroupWindowAggregate;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalLegacyTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalMiniBatchAssigner;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalRel;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalWatermarkAssigner;
import org.apache.flink.table.planner.plan.rules.physical.stream.MiniBatchIntervalInferRule$;
import org.apache.flink.table.planner.plan.trait.MiniBatchInterval;
import org.apache.flink.table.planner.plan.trait.MiniBatchIntervalTrait;
import org.apache.flink.table.planner.plan.trait.MiniBatchIntervalTrait$;
import org.apache.flink.table.planner.plan.trait.MiniBatchIntervalTraitDef$;
import org.apache.flink.table.planner.plan.trait.MiniBatchMode;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y3AAC\u0006\u0001=!)a\u0005\u0001C\u0001O!)!\u0006\u0001C\u0001W!)!\t\u0001C!\u0007\")Q\n\u0001C\u0005\u001d\u001e)Ak\u0003E\u0001+\u001a)!b\u0003E\u0001-\")aE\u0002C\u00015\"91L\u0002b\u0001\n\u0003a\u0006BB/\u0007A\u0003%qD\u0001\u000eNS:L')\u0019;dQ&sG/\u001a:wC2LeNZ3s%VdWM\u0003\u0002\r\u001b\u000511\u000f\u001e:fC6T!AD\b\u0002\u0011AD\u0017p]5dC2T!\u0001E\t\u0002\u000bI,H.Z:\u000b\u0005I\u0019\u0012\u0001\u00029mC:T!\u0001F\u000b\u0002\u000fAd\u0017M\u001c8fe*\u0011acF\u0001\u0006i\u0006\u0014G.\u001a\u0006\u00031e\tQA\u001a7j].T!AG\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0012aA8sO\u000e\u00011C\u0001\u0001 !\t\u0001C%D\u0001\"\u0015\t\u0011\"E\u0003\u0002$3\u000591-\u00197dSR,\u0017BA\u0013\"\u0005)\u0011V\r\\(qiJ+H.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\u0002\"!\u000b\u0001\u000e\u0003-\t\u0011bZ3u\u0013:\u0004X\u000f^:\u0015\u00051\u0002\u0005cA\u00178u9\u0011a\u0006\u000e\b\u0003_Ij\u0011\u0001\r\u0006\u0003cu\ta\u0001\u0010:p_Rt\u0014\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U2\u0014a\u00029bG.\fw-\u001a\u0006\u0002g%\u0011\u0001(\u000f\u0002\u0004'\u0016\f(BA\u001b7!\tYd(D\u0001=\u0015\ti$%A\u0002sK2L!a\u0010\u001f\u0003\u000fI+GNT8eK\")\u0011I\u0001a\u0001u\u00051\u0001/\u0019:f]R\fqa\u001c8NCR\u001c\u0007\u000e\u0006\u0002E\u0011B\u0011QIR\u0007\u0002m%\u0011qI\u000e\u0002\u0005+:LG\u000fC\u0003J\u0007\u0001\u0007!*\u0001\u0003dC2d\u0007C\u0001\u0011L\u0013\ta\u0015E\u0001\bSK2|\u0005\u000f\u001e*vY\u0016\u001c\u0015\r\u001c7\u0002CMDw.\u001e7e\u0003B\u0004XM\u001c3NS:L')\u0019;dQ\u0006\u001b8/[4oKJtu\u000eZ3\u0015\u0005=\u0013\u0006CA#Q\u0013\t\tfGA\u0004C_>dW-\u00198\t\u000bM#\u0001\u0019\u0001\u001e\u0002\t9|G-Z\u0001\u001b\u001b&t\u0017NQ1uG\"Le\u000e^3sm\u0006d\u0017J\u001c4feJ+H.\u001a\t\u0003S\u0019\u0019\"AB,\u0011\u0005\u0015C\u0016BA-7\u0005\u0019\te.\u001f*fMR\tQ+\u0001\u0005J\u001dN#\u0016IT\"F+\u0005y\u0012!C%O'R\u000bejQ#!\u0001")
public class MiniBatchIntervalInferRule
extends RelOptRule {
    public static RelOptRule INSTANCE() {
        return MiniBatchIntervalInferRule$.MODULE$.INSTANCE();
    }

    public Seq<RelNode> getInputs(RelNode parent) {
        return (Seq)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(parent.getInputs()).map((Function1 & Serializable & scala.Serializable)x$1 -> ((HepRelVertex)x$1).getCurrentRel(), Buffer$.MODULE$.canBuildFrom());
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        MiniBatchIntervalTrait miniBatchIntervalTrait;
        StreamPhysicalRel rel = (StreamPhysicalRel)call.rel(0);
        MiniBatchIntervalTrait miniBatchIntervalTrait2 = rel.getTraitSet().getTrait(MiniBatchIntervalTraitDef$.MODULE$.INSTANCE());
        Seq<RelNode> inputs = this.getInputs(rel);
        TableConfig tableConfig = ShortcutUtils.unwrapTableConfig(rel);
        Boolean miniBatchEnabled = (Boolean)tableConfig.get(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED);
        StreamPhysicalRel streamPhysicalRel = rel;
        if (streamPhysicalRel instanceof StreamPhysicalGroupWindowAggregate) {
            miniBatchIntervalTrait = MiniBatchIntervalTrait$.MODULE$.NO_MINIBATCH();
        } else if (streamPhysicalRel instanceof StreamPhysicalWatermarkAssigner) {
            miniBatchIntervalTrait = MiniBatchIntervalTrait$.MODULE$.NONE();
        } else if (streamPhysicalRel instanceof StreamPhysicalMiniBatchAssigner) {
            miniBatchIntervalTrait = MiniBatchIntervalTrait$.MODULE$.NONE();
        } else if (rel.requireWatermark() && Predef$.MODULE$.Boolean2boolean(miniBatchEnabled)) {
            MiniBatchInterval mergedInterval = FlinkRelOptUtil$.MODULE$.mergeMiniBatchInterval(miniBatchIntervalTrait2.getMiniBatchInterval(), new MiniBatchInterval(0L, MiniBatchMode.RowTime));
            miniBatchIntervalTrait = new MiniBatchIntervalTrait(mergedInterval);
        } else {
            miniBatchIntervalTrait = miniBatchIntervalTrait2;
        }
        MiniBatchIntervalTrait updatedTrait = miniBatchIntervalTrait;
        Seq updatedInputs = (Seq)inputs.map((Function1 & Serializable & scala.Serializable)input -> {
            MiniBatchIntervalTrait originTrait;
            if (this.shouldAppendMiniBatchAssignerNode((RelNode)input)) {
                return new StreamPhysicalMiniBatchAssigner(input.getCluster(), input.getTraitSet(), input.copy(input.getTraitSet().plus(MiniBatchIntervalTrait$.MODULE$.NONE()), input.getInputs()));
            }
            MiniBatchIntervalTrait miniBatchIntervalTrait = originTrait = input.getTraitSet().getTrait(MiniBatchIntervalTraitDef$.MODULE$.INSTANCE());
            MiniBatchIntervalTrait miniBatchIntervalTrait2 = updatedTrait;
            if (miniBatchIntervalTrait == null ? miniBatchIntervalTrait2 != null : !((Object)miniBatchIntervalTrait).equals(miniBatchIntervalTrait2)) {
                MiniBatchInterval mergedMiniBatchInterval = FlinkRelOptUtil$.MODULE$.mergeMiniBatchInterval(originTrait.getMiniBatchInterval(), updatedTrait.getMiniBatchInterval());
                MiniBatchIntervalTrait inferredTrait = new MiniBatchIntervalTrait(mergedMiniBatchInterval);
                return input.copy(input.getTraitSet().plus(inferredTrait), input.getInputs());
            }
            return input;
        }, Seq$.MODULE$.canBuildFrom());
        Seq<RelNode> seq = inputs;
        Seq seq2 = updatedInputs;
        if (seq == null ? seq2 != null : !seq.equals((Object)seq2)) {
            RelNode newRel = rel.copy(rel.getTraitSet(), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(updatedInputs));
            call.transformTo(newRel);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldAppendMiniBatchAssignerNode(RelNode node) {
        MiniBatchMode mode = node.getTraitSet().getTrait(MiniBatchIntervalTraitDef$.MODULE$.INSTANCE()).getMiniBatchInterval().getMode();
        RelNode relNode = node;
        if (relNode instanceof StreamPhysicalDataStreamScan ? true : (relNode instanceof StreamPhysicalLegacyTableSourceScan ? true : relNode instanceof StreamPhysicalTableSourceScan)) {
            MiniBatchMode miniBatchMode = mode;
            MiniBatchMode miniBatchMode2 = MiniBatchMode.RowTime;
            if (miniBatchMode == null) {
                if (miniBatchMode2 == null) return true;
            } else if (((Object)((Object)miniBatchMode)).equals((Object)miniBatchMode2)) return true;
            MiniBatchMode miniBatchMode3 = mode;
            MiniBatchMode miniBatchMode4 = MiniBatchMode.ProcTime;
            if (miniBatchMode3 != null) {
                if (!((Object)((Object)miniBatchMode3)).equals((Object)miniBatchMode4)) return false;
                return true;
            }
            if (miniBatchMode4 == null) return true;
            return false;
        }
        if (!(relNode instanceof StreamPhysicalWatermarkAssigner)) return false;
        MiniBatchMode miniBatchMode = mode;
        MiniBatchMode miniBatchMode5 = MiniBatchMode.RowTime;
        if (miniBatchMode == null) {
            if (miniBatchMode5 == null) return true;
        } else if (((Object)((Object)miniBatchMode)).equals((Object)miniBatchMode5)) return true;
        MiniBatchMode miniBatchMode6 = mode;
        MiniBatchMode miniBatchMode7 = MiniBatchMode.ProcTime;
        if (miniBatchMode6 != null) {
            if (!((Object)((Object)miniBatchMode6)).equals((Object)miniBatchMode7)) return false;
            return true;
        }
        if (miniBatchMode7 == null) return true;
        return false;
    }

    public MiniBatchIntervalInferRule() {
        super(RelOptRule.operand(StreamPhysicalRel.class, RelOptRule.any()), "MiniBatchIntervalInferRule");
    }
}

