/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.batch;

import java.util.Collections;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalRank;
import org.apache.flink.table.planner.plan.rules.physical.batch.ImmutableRemoveRedundantLocalRankRule;
import org.immutables.value.Value;

@Value.Enclosing
public class RemoveRedundantLocalRankRule
extends RelRule<RemoveRedundantLocalRankRuleConfig> {
    public static final RemoveRedundantLocalRankRule INSTANCE = RemoveRedundantLocalRankRuleConfig.DEFAULT.toRule();

    public RemoveRedundantLocalRankRule(RemoveRedundantLocalRankRuleConfig config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        BatchPhysicalRank globalRank = (BatchPhysicalRank)call.rel(0);
        BatchPhysicalRank localRank = (BatchPhysicalRank)call.rel(1);
        return globalRank.isGlobal() && !localRank.isGlobal() && globalRank.rankType() == localRank.rankType() && globalRank.partitionKey() == localRank.partitionKey() && globalRank.orderKey() == globalRank.orderKey() && globalRank.rankEnd() == localRank.rankEnd();
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        BatchPhysicalRank globalRank = (BatchPhysicalRank)call.rel(0);
        Object inputOfLocalRank = call.rel(2);
        RelNode newGlobalRank = globalRank.copy(globalRank.getTraitSet(), Collections.singletonList(inputOfLocalRank));
        call.transformTo(newGlobalRank);
    }

    @Value.Immutable(singleton=false)
    public static interface RemoveRedundantLocalRankRuleConfig
    extends RelRule.Config {
        public static final RemoveRedundantLocalRankRuleConfig DEFAULT = ImmutableRemoveRedundantLocalRankRule.RemoveRedundantLocalRankRuleConfig.builder().build().withOperandSupplier(b0 -> b0.operand(BatchPhysicalRank.class).oneInput(b1 -> b1.operand(BatchPhysicalRank.class).oneInput(b2 -> b2.operand(RelNode.class).oneInput(b3 -> b3.operand(FlinkConventions.BATCH_PHYSICAL().getInterface()).noInputs())))).withDescription("RemoveRedundantLocalRankRule").as(RemoveRedundantLocalRankRuleConfig.class);

        @Override
        default public RemoveRedundantLocalRankRule toRule() {
            return new RemoveRedundantLocalRankRule(this);
        }
    }
}

