/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.batch;

import java.io.Serializable;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.hint.JoinStrategy;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions$;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalLocalHashAggregate;
import org.apache.flink.table.planner.plan.rules.physical.batch.BatchPhysicalJoinRuleBase$;
import org.apache.flink.table.planner.plan.utils.JoinUtil$;
import org.apache.flink.table.planner.plan.utils.OperatorType;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\u0005-da\u0002\n\u0014!\u0003\r\tA\n\u0005\u0006[\u0001!\tA\f\u0005\u0006e\u0001!\tb\r\u0005\u0006'\u0002!\t\u0001\u0016\u0005\u0006Y\u0002!\t!\u001c\u0005\u0006c\u0002!\tB\u001d\u0005\u0006q\u0002!\t!\u001f\u0005\b\u0003\u000f\u0001A\u0011BA\u0005\u0011\u001d\ti\u0001\u0001C\t\u0003\u001fAq!!\u0007\u0001\t#\tY\u0002C\u0004\u0002&\u0001!\t\"a\n\t\u000f\u00055\u0002\u0001\"\u0005\u00020!9\u0011\u0011\b\u0001\u0005\n\u0005mraBA*'!\u0005\u0011Q\u000b\u0004\u0007%MA\t!!\u0017\t\u000f\u0005mc\u0002\"\u0001\u0002^!I\u0011q\f\bC\u0002\u0013\u0005\u0011\u0011\r\u0005\t\u0003Sr\u0001\u0015!\u0003\u0002d\tI\")\u0019;dQBC\u0017p]5dC2Tu.\u001b8Sk2,')Y:f\u0015\t!R#A\u0003cCR\u001c\u0007N\u0003\u0002\u0017/\u0005A\u0001\u000f[=tS\u000e\fGN\u0003\u0002\u00193\u0005)!/\u001e7fg*\u0011!dG\u0001\u0005a2\fgN\u0003\u0002\u001d;\u00059\u0001\u000f\\1o]\u0016\u0014(B\u0001\u0010 \u0003\u0015!\u0018M\u00197f\u0015\t\u0001\u0013%A\u0003gY&t7N\u0003\u0002#G\u00051\u0011\r]1dQ\u0016T\u0011\u0001J\u0001\u0004_J<7\u0001A\n\u0003\u0001\u001d\u0002\"\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u0012a!\u00118z%\u00164\u0017A\u0002\u0013j]&$H\u0005F\u00010!\tA\u0003'\u0003\u00022S\t!QK\\5u\u0003I\u0019\u0017M\\+tK*{\u0017N\\*ue\u0006$XmZ=\u0015\tQ:4i\u0013\t\u0003QUJ!AN\u0015\u0003\u000f\t{w\u000e\\3b]\")\u0001H\u0001a\u0001s\u0005!!n\\5o!\tQ\u0014)D\u0001<\u0015\taT(\u0001\u0003d_J,'B\u0001 @\u0003\r\u0011X\r\u001c\u0006\u0003\u0001\u0006\nqaY1mG&$X-\u0003\u0002Cw\t!!j\\5o\u0011\u0015!%\u00011\u0001F\u0003-!\u0018M\u00197f\u0007>tg-[4\u0011\u0005\u0019KU\"A$\u000b\u0005!k\u0012aA1qS&\u0011!j\u0012\u0002\f)\u0006\u0014G.Z\"p]\u001aLw\rC\u0003M\u0005\u0001\u0007Q*\u0001\u0007k_&t7\u000b\u001e:bi\u0016<\u0017\u0010\u0005\u0002O#6\tqJ\u0003\u0002Q7\u0005!\u0001.\u001b8u\u0013\t\u0011vJ\u0001\u0007K_&t7\u000b\u001e:bi\u0016<\u00170A\nbI\u0012dunY1m\t&\u001cH/\u001b8di\u0006;w\rF\u0002V3n\u0003\"AV,\u000e\u0003uJ!\u0001W\u001f\u0003\u000fI+GNT8eK\")!l\u0001a\u0001+\u0006!an\u001c3f\u0011\u0015a6\u00011\u0001^\u00031!\u0017n\u001d;j]\u000e$8*Z=t!\rqf-\u001b\b\u0003?\u0012t!\u0001Y2\u000e\u0003\u0005T!AY\u0013\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0013BA3*\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001a5\u0003\u0007M+\u0017O\u0003\u0002fSA\u0011\u0001F[\u0005\u0003W&\u00121!\u00138u\u0003]\u0019\u0007n\\8tKN+W.\u001b\"vS2$G)[:uS:\u001cG\u000fF\u00025]BDQa\u001c\u0003A\u0002U\u000b\u0001BY;jY\u0012\u0014V\r\u001c\u0005\u00069\u0012\u0001\r!X\u0001\u0016O\u0016$h)\u001b:tiZ\u000bG.\u001b3K_&t\u0007*\u001b8u)\r\u0019ho\u001e\t\u0004QQl\u0015BA;*\u0005\u0019y\u0005\u000f^5p]\")\u0001(\u0002a\u0001s!)A)\u0002a\u0001\u000b\u000612\r[3dW*{\u0017N\\*ue\u0006$XmZ=WC2LG\r\u0006\u0004{{z|\u00181\u0001\t\u0005Qm$D'\u0003\u0002}S\t1A+\u001e9mKJBQ\u0001\u000f\u0004A\u0002eBQ\u0001\u0012\u0004A\u0002\u0015Ca!!\u0001\u0007\u0001\u0004i\u0015!\u0005;sS\u0016$'j\\5o'R\u0014\u0018\r^3hs\"1\u0011Q\u0001\u0004A\u0002Q\n\u0001b^5uQ\"Kg\u000e^\u0001\fSN,\u0015/^5w\u0015>Lg\u000eF\u00025\u0003\u0017AQ\u0001O\u0004A\u0002e\nab\u00195fG.\u0014%o\\1eG\u0006\u001cH\u000fF\u0004{\u0003#\t\u0019\"!\u0006\t\u000baB\u0001\u0019A\u001d\t\u000b\u0011C\u0001\u0019A#\t\r\u0005]\u0001\u00021\u00015\u0003E9\u0018\u000e\u001e5Ce>\fGmY1ti\"Kg\u000e^\u0001\u0011G\",7m[*ik\u001a4G.\u001a%bg\"$rA_A\u000f\u0003?\t\t\u0003C\u00039\u0013\u0001\u0007\u0011\bC\u0003E\u0013\u0001\u0007Q\t\u0003\u0004\u0002$%\u0001\r\u0001N\u0001\u0014o&$\bn\u00155vM\u001adW\rS1tQ\"Kg\u000e^\u0001\u0013G\",7m[*peRlUM]4f\u0015>Lg\u000eF\u00035\u0003S\tY\u0003C\u00039\u0015\u0001\u0007\u0011\bC\u0003E\u0015\u0001\u0007Q)A\tdQ\u0016\u001c7NT3ti2{w\u000e\u001d&pS:$rA_A\u0019\u0003g\t)\u0004C\u00039\u0017\u0001\u0007\u0011\bC\u0003E\u0017\u0001\u0007Q\t\u0003\u0004\u00028-\u0001\r\u0001N\u0001\u0011o&$\bNT3ti2{w\u000e\u001d%j]R\fQcZ3u\r&\u00148\u000f^!sO&s'j\\5o\u0011&tG\u000f\u0006\u0004\u0002>\u00055\u0013q\n\t\u0005\u0003\u007f\t9E\u0004\u0003\u0002B\u0005\r\u0003C\u00011*\u0013\r\t)%K\u0001\u0007!J,G-\u001a4\n\t\u0005%\u00131\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0015\u0013\u0006C\u00039\u0019\u0001\u0007\u0011\bC\u0004\u0002R1\u0001\r!!\u0010\u0002\u0019)|\u0017N\u001c%j]Rt\u0015-\\3\u00023\t\u000bGo\u00195QQf\u001c\u0018nY1m\u0015>LgNU;mK\n\u000b7/\u001a\t\u0004\u0003/rQ\"A\n\u0014\u000599\u0013A\u0002\u001fj]&$h\b\u0006\u0002\u0002V\u0005\u00113+R'J?*{\u0015JT0C+&cEi\u0018#J'RKej\u0011+`\u001d\u00123vLU!U\u0013>+\"!a\u0019\u0011\u0007!\n)'C\u0002\u0002h%\u0012a\u0001R8vE2,\u0017aI*F\u001b&{&jT%O?\n+\u0016\n\u0014#`\t&\u001bF+\u0013(D)~sEIV0S\u0003RKu\n\t")
public interface BatchPhysicalJoinRuleBase {
    public static double SEMI_JOIN_BUILD_DISTINCT_NDV_RATIO() {
        return BatchPhysicalJoinRuleBase$.MODULE$.SEMI_JOIN_BUILD_DISTINCT_NDV_RATIO();
    }

    public static /* synthetic */ boolean canUseJoinStrategy$(BatchPhysicalJoinRuleBase $this, Join join, TableConfig tableConfig, JoinStrategy joinStrategy) {
        return $this.canUseJoinStrategy(join, tableConfig, joinStrategy);
    }

    default public boolean canUseJoinStrategy(Join join, TableConfig tableConfig, JoinStrategy joinStrategy) {
        Option<JoinStrategy> firstValidJoinHint = this.getFirstValidJoinHint(join, tableConfig);
        if (firstValidJoinHint.nonEmpty()) {
            return ((Enum)firstValidJoinHint.get()).equals((Object)joinStrategy);
        }
        Tuple2<Object, Object> tuple2 = this.checkJoinStrategyValid(join, tableConfig, joinStrategy, false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean isValid = tuple2._1$mcZ$sp();
        boolean isValid2 = isValid;
        return isValid2;
    }

    public static /* synthetic */ RelNode addLocalDistinctAgg$(BatchPhysicalJoinRuleBase $this, RelNode node, Seq distinctKeys) {
        return $this.addLocalDistinctAgg(node, (Seq<Object>)distinctKeys);
    }

    default public RelNode addLocalDistinctAgg(RelNode node, Seq<Object> distinctKeys) {
        RelTraitSet localRequiredTraitSet = node.getTraitSet().replace(FlinkConventions$.MODULE$.BATCH_PHYSICAL());
        RelNode newInput = RelOptRule.convert(node, localRequiredTraitSet);
        RelTraitSet providedTraitSet = localRequiredTraitSet;
        return new BatchPhysicalLocalHashAggregate(node.getCluster(), providedTraitSet, newInput, node.getRowType(), node.getRowType(), (int[])distinctKeys.toArray(ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), false, (Seq<Tuple2<AggregateCall, UserDefinedFunction>>)((Seq)Nil$.MODULE$));
    }

    public static /* synthetic */ boolean chooseSemiBuildDistinct$(BatchPhysicalJoinRuleBase $this, RelNode buildRel, Seq distinctKeys) {
        return $this.chooseSemiBuildDistinct(buildRel, (Seq<Object>)distinctKeys);
    }

    default public boolean chooseSemiBuildDistinct(RelNode buildRel, Seq<Object> distinctKeys) {
        RelMetadataQuery mq = buildRel.getCluster().getMetadataQuery();
        Double inputRows = mq.getRowCount(buildRel);
        Double ndvOfGroupKey = mq.getDistinctRowCount(buildRel, ImmutableBitSet.of((int[])distinctKeys.toArray(ClassTag$.MODULE$.Int())), null);
        if (ndvOfGroupKey == null) {
            return false;
        }
        return Predef$.MODULE$.Double2double(ndvOfGroupKey) / Predef$.MODULE$.Double2double(inputRows) < BatchPhysicalJoinRuleBase$.MODULE$.SEMI_JOIN_BUILD_DISTINCT_NDV_RATIO();
    }

    public static /* synthetic */ Option getFirstValidJoinHint$(BatchPhysicalJoinRuleBase $this, Join join, TableConfig tableConfig) {
        return $this.getFirstValidJoinHint(join, tableConfig);
    }

    default public Option<JoinStrategy> getFirstValidJoinHint(Join join, TableConfig tableConfig) {
        Option option;
        Object object = new Object();
        try {
            ImmutableList<RelHint> allHints = join.getHints();
            allHints.forEach(relHint -> {
                if (JoinStrategy.isJoinStrategy(relHint.hintName)) {
                    JoinStrategy joinStrategy = JoinStrategy.valueOf(relHint.hintName);
                    Tuple2<Object, Object> tuple2 = this.checkJoinStrategyValid(join, tableConfig, joinStrategy, true);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    boolean isValid = tuple2._1$mcZ$sp();
                    boolean isValid2 = isValid;
                    if (isValid2) {
                        throw new NonLocalReturnControl(object, (Object)new Some((Object)joinStrategy));
                    }
                    return;
                }
            });
            option = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public static /* synthetic */ Tuple2 checkJoinStrategyValid$(BatchPhysicalJoinRuleBase $this, Join join, TableConfig tableConfig, JoinStrategy triedJoinStrategy, boolean withHint) {
        return $this.checkJoinStrategyValid(join, tableConfig, triedJoinStrategy, withHint);
    }

    default public Tuple2<Object, Object> checkJoinStrategyValid(Join join, TableConfig tableConfig, JoinStrategy triedJoinStrategy, boolean withHint) {
        if (withHint && !join.getJoinType().projectsRight()) {
            return new Tuple2.mcZZ.sp(false, false);
        }
        JoinStrategy joinStrategy = triedJoinStrategy;
        if (((Object)((Object)JoinStrategy.BROADCAST)).equals((Object)joinStrategy)) {
            return this.checkBroadcast(join, tableConfig, withHint);
        }
        if (((Object)((Object)JoinStrategy.SHUFFLE_HASH)).equals((Object)joinStrategy)) {
            return this.checkShuffleHash(join, tableConfig, withHint);
        }
        if (((Object)((Object)JoinStrategy.SHUFFLE_MERGE)).equals((Object)joinStrategy)) {
            return new Tuple2.mcZZ.sp(this.checkSortMergeJoin(join, tableConfig), false);
        }
        if (((Object)((Object)JoinStrategy.NEST_LOOP)).equals((Object)joinStrategy)) {
            return this.checkNestLoopJoin(join, tableConfig, withHint);
        }
        if (((Object)((Object)JoinStrategy.LOOKUP)).equals((Object)joinStrategy)) {
            return new Tuple2.mcZZ.sp(false, false);
        }
        throw new ValidationException(new StringBuilder(24).append("Unknown join strategy : ").append((Object)triedJoinStrategy).toString());
    }

    private boolean isEquivJoin(Join join) {
        JoinInfo joinInfo = join.analyzeCondition();
        return !joinInfo.pairs().isEmpty();
    }

    public static /* synthetic */ Tuple2 checkBroadcast$(BatchPhysicalJoinRuleBase $this, Join join, TableConfig tableConfig, boolean withBroadcastHint) {
        return $this.checkBroadcast(join, tableConfig, withBroadcastHint);
    }

    default public Tuple2<Object, Object> checkBroadcast(Join join, TableConfig tableConfig, boolean withBroadcastHint) {
        if (!this.isEquivJoin(join) || TableConfigUtils.isOperatorDisabled(tableConfig, OperatorType.BroadcastHashJoin)) {
            return new Tuple2.mcZZ.sp(false, false);
        }
        if (withBroadcastHint) {
            boolean isLeftToBroadcastInHint = this.getFirstArgInJoinHint(join, JoinStrategy.BROADCAST.getJoinHintName()).equals("LEFT");
            JoinRelType joinRelType = join.getJoinType();
            if (((Object)((Object)JoinRelType.LEFT)).equals((Object)joinRelType)) {
                return new Tuple2.mcZZ.sp(!isLeftToBroadcastInHint, false);
            }
            if (((Object)((Object)JoinRelType.RIGHT)).equals((Object)joinRelType)) {
                return new Tuple2.mcZZ.sp(isLeftToBroadcastInHint, true);
            }
            if (((Object)((Object)JoinRelType.FULL)).equals((Object)joinRelType)) {
                return new Tuple2.mcZZ.sp(false, false);
            }
            if (((Object)((Object)JoinRelType.INNER)).equals((Object)joinRelType)) {
                return new Tuple2.mcZZ.sp(true, isLeftToBroadcastInHint);
            }
            if (((Object)((Object)JoinRelType.SEMI)).equals((Object)joinRelType) ? true : ((Object)((Object)JoinRelType.ANTI)).equals((Object)joinRelType)) {
                return new Tuple2.mcZZ.sp(false, false);
            }
            throw new MatchError((Object)joinRelType);
        }
        Object object = tableConfig.get(OptimizerConfigOptions.TABLE_OPTIMIZER_ADAPTIVE_BROADCAST_JOIN_STRATEGY);
        OptimizerConfigOptions.AdaptiveBroadcastJoinStrategy adaptiveBroadcastJoinStrategy = OptimizerConfigOptions.AdaptiveBroadcastJoinStrategy.RUNTIME_ONLY;
        if (!(object != null ? !object.equals(adaptiveBroadcastJoinStrategy) : adaptiveBroadcastJoinStrategy != null)) {
            return new Tuple2.mcZZ.sp(false, false);
        }
        Double leftSize = JoinUtil$.MODULE$.binaryRowRelNodeSize(join.getLeft());
        Double rightSize = JoinUtil$.MODULE$.binaryRowRelNodeSize(join.getRight());
        if (leftSize == null || rightSize == null) {
            return new Tuple2.mcZZ.sp(false, false);
        }
        Long threshold = (Long)tableConfig.get(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD);
        boolean rightSizeSmallerThanThreshold = Predef$.MODULE$.Double2double(rightSize) <= (double)Predef$.MODULE$.Long2long(threshold);
        boolean leftSizeSmallerThanThreshold = Predef$.MODULE$.Double2double(leftSize) <= (double)Predef$.MODULE$.Long2long(threshold);
        boolean leftSmallerThanRight = Predef$.MODULE$.Double2double(leftSize) < Predef$.MODULE$.Double2double(rightSize);
        JoinRelType joinRelType = join.getJoinType();
        if (((Object)((Object)JoinRelType.LEFT)).equals((Object)joinRelType)) {
            return new Tuple2.mcZZ.sp(rightSizeSmallerThanThreshold, false);
        }
        if (((Object)((Object)JoinRelType.RIGHT)).equals((Object)joinRelType)) {
            return new Tuple2.mcZZ.sp(leftSizeSmallerThanThreshold, true);
        }
        if (((Object)((Object)JoinRelType.FULL)).equals((Object)joinRelType)) {
            return new Tuple2.mcZZ.sp(false, false);
        }
        if (((Object)((Object)JoinRelType.INNER)).equals((Object)joinRelType)) {
            return new Tuple2.mcZZ.sp(leftSizeSmallerThanThreshold || rightSizeSmallerThanThreshold, leftSmallerThanRight);
        }
        if (((Object)((Object)JoinRelType.SEMI)).equals((Object)joinRelType) ? true : ((Object)((Object)JoinRelType.ANTI)).equals((Object)joinRelType)) {
            return new Tuple2.mcZZ.sp(rightSizeSmallerThanThreshold, false);
        }
        throw new MatchError((Object)joinRelType);
    }

    public static /* synthetic */ Tuple2 checkShuffleHash$(BatchPhysicalJoinRuleBase $this, Join join, TableConfig tableConfig, boolean withShuffleHashHint) {
        return $this.checkShuffleHash(join, tableConfig, withShuffleHashHint);
    }

    default public Tuple2<Object, Object> checkShuffleHash(Join join, TableConfig tableConfig, boolean withShuffleHashHint) {
        if (!this.isEquivJoin(join) || TableConfigUtils.isOperatorDisabled(tableConfig, OperatorType.ShuffleHashJoin)) {
            return new Tuple2.mcZZ.sp(false, false);
        }
        if (withShuffleHashHint) {
            boolean isLeftToBuild = this.getFirstArgInJoinHint(join, JoinStrategy.SHUFFLE_HASH.getJoinHintName()).equals("LEFT");
            return new Tuple2.mcZZ.sp(true, isLeftToBuild);
        }
        Double leftSize = JoinUtil$.MODULE$.binaryRowRelNodeSize(join.getLeft());
        Double rightSize = JoinUtil$.MODULE$.binaryRowRelNodeSize(join.getRight());
        boolean leftIsBuild = leftSize == null || rightSize == null || BoxesRunTime.equalsNumNum((Number)leftSize, (Number)rightSize) ? join.getJoinType().projectsRight() : Predef$.MODULE$.Double2double(leftSize) < Predef$.MODULE$.Double2double(rightSize);
        return new Tuple2.mcZZ.sp(true, leftIsBuild);
    }

    public static /* synthetic */ boolean checkSortMergeJoin$(BatchPhysicalJoinRuleBase $this, Join join, TableConfig tableConfig) {
        return $this.checkSortMergeJoin(join, tableConfig);
    }

    default public boolean checkSortMergeJoin(Join join, TableConfig tableConfig) {
        return this.isEquivJoin(join) && !TableConfigUtils.isOperatorDisabled(tableConfig, OperatorType.SortMergeJoin);
    }

    public static /* synthetic */ Tuple2 checkNestLoopJoin$(BatchPhysicalJoinRuleBase $this, Join join, TableConfig tableConfig, boolean withNestLoopHint) {
        return $this.checkNestLoopJoin(join, tableConfig, withNestLoopHint);
    }

    default public Tuple2<Object, Object> checkNestLoopJoin(Join join, TableConfig tableConfig, boolean withNestLoopHint) {
        boolean bl;
        if (TableConfigUtils.isOperatorDisabled(tableConfig, OperatorType.NestedLoopJoin)) {
            return new Tuple2.mcZZ.sp(false, false);
        }
        if (withNestLoopHint) {
            bl = this.getFirstArgInJoinHint(join, JoinStrategy.NEST_LOOP.getJoinHintName()).equals("LEFT");
        } else {
            JoinRelType joinRelType = join.getJoinType();
            if (((Object)((Object)JoinRelType.LEFT)).equals((Object)joinRelType)) {
                bl = false;
            } else if (((Object)((Object)JoinRelType.RIGHT)).equals((Object)joinRelType)) {
                bl = true;
            } else if (((Object)((Object)JoinRelType.INNER)).equals((Object)joinRelType) ? true : ((Object)((Object)JoinRelType.FULL)).equals((Object)joinRelType)) {
                Double leftSize = JoinUtil$.MODULE$.binaryRowRelNodeSize(join.getLeft());
                Double rightSize = JoinUtil$.MODULE$.binaryRowRelNodeSize(join.getRight());
                bl = leftSize == null || rightSize == null ? true : Predef$.MODULE$.Double2double(leftSize) <= Predef$.MODULE$.Double2double(rightSize);
            } else if (((Object)((Object)JoinRelType.SEMI)).equals((Object)joinRelType) ? true : ((Object)((Object)JoinRelType.ANTI)).equals((Object)joinRelType)) {
                bl = false;
            } else {
                throw new MatchError((Object)joinRelType);
            }
        }
        boolean isLeftToBuild = bl;
        return new Tuple2.mcZZ.sp(true, isLeftToBuild);
    }

    private String getFirstArgInJoinHint(Join join, String joinHintName) {
        Object object = new Object();
        try {
            join.getHints().forEach(hint -> {
                if (hint.hintName.equals(joinHintName)) {
                    throw new NonLocalReturnControl(object, (Object)hint.listOptions.get(0));
                }
            });
            throw new TableException(String.format("Fail to find the join hint `%s` among `%s`", joinHintName, ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(join.getHints()).map((Function1 & Serializable & scala.Serializable)hint -> hint.hintName, Buffer$.MODULE$.canBuildFrom())).mkString(",")));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (String)ex.value();
        }
    }

    public static void $init$(BatchPhysicalJoinRuleBase $this) {
    }
}

