/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.Collections;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.legacy.sources.LimitableTableSource;
import org.apache.flink.table.legacy.sources.TableSource;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalLegacyTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalSort;
import org.apache.flink.table.planner.plan.rules.logical.ImmutablePushLimitIntoLegacyTableSourceScanRule;
import org.apache.flink.table.planner.plan.schema.FlinkPreparingTableBase;
import org.apache.flink.table.planner.plan.schema.LegacyTableSourceTable;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.immutables.value.Value;

@Internal
@Value.Enclosing
public class PushLimitIntoLegacyTableSourceScanRule
extends RelRule<PushLimitIntoLegacyTableSourceScanRuleConfig> {
    public static final PushLimitIntoLegacyTableSourceScanRule INSTANCE = PushLimitIntoLegacyTableSourceScanRuleConfig.DEFAULT.toRule();

    protected PushLimitIntoLegacyTableSourceScanRule(PushLimitIntoLegacyTableSourceScanRuleConfig config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        LegacyTableSourceTable table;
        boolean onlyLimit;
        Sort sort = (Sort)call.rel(0);
        boolean bl = onlyLimit = sort.getCollation().getFieldCollations().isEmpty() && sort.fetch != null;
        if (onlyLimit && (table = call.rel(1).getTable().unwrap(LegacyTableSourceTable.class)) != null) {
            TableSource tableSource = table.tableSource();
            return tableSource instanceof LimitableTableSource && !((LimitableTableSource)tableSource).isLimitPushedDown();
        }
        return false;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        FlinkLogicalLegacyTableSourceScan scan = (FlinkLogicalLegacyTableSourceScan)call.rel(1);
        LegacyTableSourceTable tableSourceTable = scan.getTable().unwrap(LegacyTableSourceTable.class);
        int offset = sort.offset == null ? 0 : RexLiteral.intValue(sort.offset);
        int limit = offset + RexLiteral.intValue(sort.fetch);
        RelBuilder relBuilder = call.builder();
        LegacyTableSourceTable newRelOptTable = this.applyLimit(limit, tableSourceTable);
        FlinkLogicalLegacyTableSourceScan newScan = scan.copy(scan.getTraitSet(), newRelOptTable);
        TableSource newTableSource = newRelOptTable.unwrap(LegacyTableSourceTable.class).tableSource();
        TableSource oldTableSource = tableSourceTable.unwrap(LegacyTableSourceTable.class).tableSource();
        if (((LimitableTableSource)newTableSource).isLimitPushedDown() && newTableSource.explainSource().equals(oldTableSource.explainSource())) {
            throw new TableException("Failed to push limit into table source! table source with pushdown capability must override and change explainSource() API to explain the pushdown applied!");
        }
        call.transformTo(sort.copy(sort.getTraitSet(), Collections.singletonList(newScan)));
    }

    private LegacyTableSourceTable applyLimit(long limit, FlinkPreparingTableBase relOptTable) {
        LegacyTableSourceTable tableSourceTable = relOptTable.unwrap(LegacyTableSourceTable.class);
        LimitableTableSource limitedSource = (LimitableTableSource)tableSourceTable.tableSource();
        TableSource newTableSource = limitedSource.applyLimit(limit);
        FlinkStatistic statistic = relOptTable.getStatistic();
        long newRowCount = statistic.getRowCount() != null ? Math.min(limit, statistic.getRowCount().longValue()) : limit;
        TableStats newTableStats = new TableStats(newRowCount);
        FlinkStatistic newStatistic = FlinkStatistic.builder().statistic(statistic).tableStats(newTableStats).build();
        return tableSourceTable.copy(newTableSource, newStatistic);
    }

    @Value.Immutable(singleton=false)
    public static interface PushLimitIntoLegacyTableSourceScanRuleConfig
    extends RelRule.Config {
        public static final PushLimitIntoLegacyTableSourceScanRuleConfig DEFAULT = ImmutablePushLimitIntoLegacyTableSourceScanRule.PushLimitIntoLegacyTableSourceScanRuleConfig.builder().operandSupplier(b0 -> b0.operand(FlinkLogicalSort.class).oneInput(b1 -> b1.operand(FlinkLogicalLegacyTableSourceScan.class).noInputs())).description("PushLimitIntoLegacyTableSourceScanRule").build().as(PushLimitIntoLegacyTableSourceScanRuleConfig.class);

        @Override
        default public PushLimitIntoLegacyTableSourceScanRule toRule() {
            return new PushLimitIntoLegacyTableSourceScanRule(this);
        }
    }
}

