/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.util.List;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalSnapshot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.plan.rules.logical.LogicalCorrelateToJoinFromTemporalTableRule;
import org.apache.flink.table.planner.plan.schema.TimeIndicatorRelDataType;
import org.apache.flink.table.planner.plan.utils.TemporalJoinUtil$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a!B\u0005\u000b\u0003\u0003Y\u0002\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\t\u0011!\u0002!\u0011!Q\u0001\n%BQA\u000e\u0001\u0005\u0002]BQa\u000f\u0001\u0005\u0012qBQ!\u0015\u0001\u0005\u0012ICQa\u0018\u0001\u0005B\u0001DQ!\u001b\u0001\u0005\n)DQ\u0001 \u0001\u0005\nu\u0014!\u0007T8hS\u000e\fGnQ8se\u0016d\u0017\r^3U_*{\u0017N\u001c$s_6<UM\\3sC2$V-\u001c9pe\u0006dG+\u00192mKJ+H.\u001a\u0006\u0003\u00171\tq\u0001\\8hS\u000e\fGN\u0003\u0002\u000e\u001d\u0005)!/\u001e7fg*\u0011q\u0002E\u0001\u0005a2\fgN\u0003\u0002\u0012%\u00059\u0001\u000f\\1o]\u0016\u0014(BA\n\u0015\u0003\u0015!\u0018M\u00197f\u0015\t)b#A\u0003gY&t7N\u0003\u0002\u00181\u00051\u0011\r]1dQ\u0016T\u0011!G\u0001\u0004_J<7\u0001A\n\u0003\u0001q\u0001\"!\b\u0010\u000e\u0003)I!a\b\u0006\u0003W1{w-[2bY\u000e{'O]3mCR,Gk\u001c&pS:4%o\\7UK6\u0004xN]1m)\u0006\u0014G.\u001a*vY\u0016\fqa\u001c9fe\u0006tG\r\u0005\u0002#M5\t1E\u0003\u0002\u0010I)\u0011QEF\u0001\bG\u0006d7-\u001b;f\u0013\t93EA\tSK2|\u0005\u000f\u001e*vY\u0016|\u0005/\u001a:b]\u0012\f1\u0002Z3tGJL\u0007\u000f^5p]B\u0011!f\r\b\u0003WE\u0002\"\u0001L\u0018\u000e\u00035R!A\f\u000e\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0003\u0019\u0001&/\u001a3fM&\u0011A'\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Iz\u0013A\u0002\u001fj]&$h\bF\u00029si\u0002\"!\b\u0001\t\u000b\u0001\u001a\u0001\u0019A\u0011\t\u000b!\u001a\u0001\u0019A\u0015\u0002;\u0015DHO]1diJKw\r\u001b;Fm\u0016tG\u000fV5nK&s\u0007/\u001e;SK\u001a$2!P$P!\rqt(Q\u0007\u0002_%\u0011\u0001i\f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\t+U\"A\"\u000b\u0005\u0011#\u0013a\u0001:fq&\u0011ai\u0011\u0002\b%\u0016Dhj\u001c3f\u0011\u0015AE\u00011\u0001J\u0003%aWM\u001a;J]B,H\u000f\u0005\u0002K\u001b6\t1J\u0003\u0002MI\u0005\u0019!/\u001a7\n\u00059[%a\u0002*fY:{G-\u001a\u0005\u0006!\u0012\u0001\r!S\u0001\u000be&<\u0007\u000e^%oaV$\u0018aG3yiJ\f7\r^*oCB\u001c\bn\u001c;US6,\u0017J\u001c9viJ+g\rF\u0002T/b\u00032AP U!\t\u0011U+\u0003\u0002W\u0007\nY!+\u001a=J]B,HOU3g\u0011\u0015AU\u00011\u0001J\u0011\u0015IV\u00011\u0001[\u0003!\u0019h.\u00199tQ>$\bCA.^\u001b\u0005a&BA\u0006L\u0013\tqFLA\bM_\u001eL7-\u00197T]\u0006\u00048\u000f[8u\u0003\u001dyg.T1uG\"$\"!\u00193\u0011\u0005y\u0012\u0017BA20\u0005\u0011)f.\u001b;\t\u000b\u00154\u0001\u0019\u00014\u0002\t\r\fG\u000e\u001c\t\u0003E\u001dL!\u0001[\u0012\u0003\u001dI+Gn\u00149u%VdWmQ1mY\u0006yQ\r\u001f;sC\u000e$(j\\5o\u0017\u0016L8\u000f\u0006\u0002loB!a\b\u001c8o\u0013\tiwF\u0001\u0004UkBdWM\r\t\u0004_R\feB\u00019s\u001d\ta\u0013/C\u00011\u0013\t\u0019x&A\u0004qC\u000e\\\u0017mZ3\n\u0005U4(aA*fc*\u00111o\f\u0005\u0006q\u001e\u0001\r!_\u0001\u000bC\u000e$X/\u00197K_&t\u0007CA.{\u0013\tYHLA\u0006M_\u001eL7-\u00197K_&t\u0017AG5t%><H+[7f)\u0016l\u0007o\u001c:bYR\u000b'\r\\3K_&tGc\u0001@\u0002\u0004A\u0011ah`\u0005\u0004\u0003\u0003y#a\u0002\"p_2,\u0017M\u001c\u0005\u00063\"\u0001\rA\u0017")
public abstract class LogicalCorrelateToJoinFromGeneralTemporalTableRule
extends LogicalCorrelateToJoinFromTemporalTableRule {
    public Option<RexNode> extractRightEventTimeInputRef(RelNode leftInput, RelNode rightInput) {
        Buffer rightFields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(rightInput.getRowType().getFieldList()).asScala();
        Buffer timeAttributeFields = (Buffer)rightFields.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)LogicalCorrelateToJoinFromGeneralTemporalTableRule.$anonfun$extractRightEventTimeInputRef$1(f)));
        if (timeAttributeFields.length() == 1) {
            int timeColIndex = leftInput.getRowType().getFieldCount() + rightFields.indexOf(JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(timeAttributeFields).get(0));
            RelDataType timeColDataType = ((RelDataTypeField)JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(timeAttributeFields).get(0)).getType();
            RexBuilder rexBuilder = rightInput.getCluster().getRexBuilder();
            return new Some((Object)rexBuilder.makeInputRef(timeColDataType, timeColIndex));
        }
        return None$.MODULE$;
    }

    public Option<RexInputRef> extractSnapshotTimeInputRef(RelNode leftInput, LogicalSnapshot snapshot) {
        RelDataTypeField periodField;
        RelDataType leftRowType = leftInput.getRowType();
        List<RelDataTypeField> leftFields = leftRowType.getFieldList();
        if (leftFields.contains(periodField = ((RexFieldAccess)snapshot.getPeriod()).getField())) {
            int index = leftRowType.getFieldList().indexOf(periodField);
            return new Some((Object)RexInputRef.of(index, leftRowType));
        }
        return None$.MODULE$;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode relNode;
        RexNode rexNode;
        RelNode rewriteJoin;
        LogicalCorrelate correlate = (LogicalCorrelate)call.rel(0);
        Object leftInput = call.rel(1);
        RexNode filterCondition = this.getFilterCondition(call);
        LogicalSnapshot snapshot = this.getLogicalSnapshot(call);
        RelDataType leftRowType = leftInput.getRowType();
        RexNode joinCondition = this.decorrelate(filterCondition, leftRowType, correlate.getCorrelationId());
        this.validateSnapshotInCorrelate(snapshot, correlate);
        RexBuilder rexBuilder = correlate.getCluster().getRexBuilder();
        RelBuilder relBuilder = call.builder();
        relBuilder.push((RelNode)leftInput);
        relBuilder.push(snapshot);
        LogicalJoin nonPushedJoin = (LogicalJoin)relBuilder.join(correlate.getJoinType(), joinCondition).build();
        RelNode relNode2 = rewriteJoin = RelOptUtil.pushDownJoinConditions((Join)nonPushedJoin, relBuilder);
        LogicalJoin actualJoin = relNode2 instanceof LogicalJoin ? (LogicalJoin)rewriteJoin : (LogicalJoin)rewriteJoin.getInput(0);
        Tuple2<Seq<RexNode>, Seq<RexNode>> tuple2 = this.extractJoinKeys(actualJoin);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq leftJoinKey = (Seq)tuple2._1();
        Seq rightJoinKey = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)leftJoinKey, (Object)rightJoinKey);
        Seq leftJoinKey2 = (Seq)tuple22._1();
        Seq rightJoinKey2 = (Seq)tuple22._2();
        RexInputRef snapshotTimeInputRef = (RexInputRef)this.extractSnapshotTimeInputRef(actualJoin.getLeft(), snapshot).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ValidationException("Temporal Table Join requires time attribute in the left table, but no time attribute found.");
        });
        if (this.isRowTimeTemporalTableJoin(snapshot)) {
            Option<RexNode> rightTimeInputRef = this.extractRightEventTimeInputRef(actualJoin.getLeft(), actualJoin.getRight());
            if (rightTimeInputRef.isEmpty() || !FlinkTypeFactory$.MODULE$.isRowtimeIndicatorType(((RexNode)rightTimeInputRef.get()).getType())) {
                throw new ValidationException(new StringBuilder(139).append("Event-Time Temporal Table Join requires both").append(" primary key and row time attribute in versioned table,").append(" but no row time attribute can be found.").toString());
            }
            SqlTypeName sqlTypeName = snapshotTimeInputRef.getType().getSqlTypeName();
            SqlTypeName sqlTypeName2 = ((RexNode)rightTimeInputRef.get()).getType().getSqlTypeName();
            if (sqlTypeName == null ? sqlTypeName2 != null : !((Object)((Object)sqlTypeName)).equals((Object)sqlTypeName2)) {
                throw new ValidationException(String.format("Event-Time Temporal Table Join requires same rowtime type in left table and versioned table, but the rowtime types are %s and %s.", ((Object)snapshotTimeInputRef.getType()).toString(), ((Object)((RexNode)rightTimeInputRef.get()).getType()).toString()));
            }
            rexNode = TemporalJoinUtil$.MODULE$.makeInitialRowTimeTemporalTableJoinCondCall(rexBuilder, snapshotTimeInputRef, (RexNode)rightTimeInputRef.get(), (Seq<RexNode>)leftJoinKey2, (Seq<RexNode>)rightJoinKey2);
        } else {
            rexNode = TemporalJoinUtil$.MODULE$.makeInitialProcTimeTemporalTableJoinConCall(rexBuilder, snapshotTimeInputRef, (Seq<RexNode>)leftJoinKey2, (Seq<RexNode>)rightJoinKey2);
        }
        RexNode temporalCondition = rexNode;
        RelBuilder builder = call.builder();
        RexNode condition = builder.and(actualJoin.getCondition(), temporalCondition);
        LogicalJoin joinWithTemporalCondition = actualJoin.copy(actualJoin.getTraitSet(), condition, actualJoin.getLeft(), actualJoin.getRight(), actualJoin.getJoinType(), actualJoin.isSemiJoinDone());
        LogicalJoin logicalJoin = actualJoin;
        RelNode relNode3 = rewriteJoin;
        if (logicalJoin == null ? relNode3 != null : !((Object)logicalJoin).equals(relNode3)) {
            rewriteJoin.replaceInput(0, joinWithTemporalCondition);
            relNode = rewriteJoin;
        } else {
            relNode = joinWithTemporalCondition;
        }
        LogicalJoin temporalJoin = relNode;
        call.transformTo(temporalJoin);
    }

    private Tuple2<Seq<RexNode>, Seq<RexNode>> extractJoinKeys(LogicalJoin actualJoin) {
        JoinInfo joinInfo = actualJoin.analyzeCondition();
        RelNode leftInput = actualJoin.getInput(0);
        RelNode rightInput = actualJoin.getInput(1);
        RexBuilder rexBuilder = actualJoin.getCluster().getRexBuilder();
        Buffer leftJoinKey = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer((List)joinInfo.leftKeys).map((Function1 & Serializable & scala.Serializable)i -> rexBuilder.makeInputRef(leftInput, Predef$.MODULE$.Integer2int(i)), Buffer$.MODULE$.canBuildFrom());
        int leftFieldCnt = leftInput.getRowType().getFieldCount();
        Buffer rightJoinKey = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer((List)joinInfo.rightKeys).map((Function1 & Serializable & scala.Serializable)i -> {
            RelDataType rightKeyType = rightInput.getRowType().getFieldList().get(Predef$.MODULE$.Integer2int(i)).getType();
            return rexBuilder.makeInputRef(rightKeyType, leftFieldCnt + Predef$.MODULE$.Integer2int(i));
        }, Buffer$.MODULE$.canBuildFrom());
        if (leftJoinKey.isEmpty() || rightJoinKey.isEmpty()) {
            throw new ValidationException("Currently the join key in Temporal Table Join can not be empty.");
        }
        return new Tuple2((Object)leftJoinKey, (Object)rightJoinKey);
    }

    private boolean isRowTimeTemporalTableJoin(LogicalSnapshot snapshot) {
        TimeIndicatorRelDataType timeIndicatorRelDataType;
        RelDataType relDataType = snapshot.getPeriod().getType();
        return relDataType instanceof TimeIndicatorRelDataType && (timeIndicatorRelDataType = (TimeIndicatorRelDataType)relDataType).isEventTime();
    }

    public static final /* synthetic */ boolean $anonfun$extractRightEventTimeInputRef$1(RelDataTypeField f) {
        return f.getType() instanceof TimeIndicatorRelDataType && ((TimeIndicatorRelDataType)f.getType()).isEventTime();
    }

    public LogicalCorrelateToJoinFromGeneralTemporalTableRule(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }
}

