/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.reuse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Union;
import org.apache.flink.table.planner.plan.abilities.sink.SinkAbilitySpec;
import org.apache.flink.table.planner.plan.nodes.calcite.Sink;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalSink;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalUnion;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalSink;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalUnion;
import org.apache.flink.table.planner.plan.utils.RelExplainUtil;
import org.apache.flink.util.Preconditions;

public class SinkReuser {
    private final boolean isStreamingMode;

    public SinkReuser(boolean isStreamingMode) {
        this.isStreamingMode = isStreamingMode;
    }

    public List<RelNode> reuseDuplicatedSink(List<RelNode> relNodes) {
        List<Sink> allSinkNodes = relNodes.stream().filter(node -> node instanceof Sink).map(node -> (Sink)node).collect(Collectors.toList());
        List<ReusableSinkGroup> reusableSinkGroups = this.groupReusableSink(allSinkNodes);
        Set<Sink> reusedSinkNodes = this.reuseSinkAndAddUnion(reusableSinkGroups);
        return relNodes.stream().filter(root -> !(root instanceof Sink) || reusedSinkNodes.contains(root)).collect(Collectors.toList());
    }

    private Set<Sink> reuseSinkAndAddUnion(List<ReusableSinkGroup> reusableSinkGroups) {
        Set<Sink> reusedSinkNodes = Collections.newSetFromMap(new IdentityHashMap());
        reusableSinkGroups.forEach(group -> {
            List<Sink> originalSinks = group.originalSinks;
            if (originalSinks.size() <= 1) {
                Preconditions.checkState((originalSinks.size() == 1 ? 1 : 0) != 0);
                reusedSinkNodes.add(originalSinks.get(0));
                return;
            }
            ArrayList<RelNode> allSinkInputs = new ArrayList<RelNode>();
            for (Sink sinkNode : originalSinks) {
                allSinkInputs.add(sinkNode.getInput());
            }
            Sink reusedSink = originalSinks.get(0);
            Union unionForReusedSinks = this.isStreamingMode ? new StreamPhysicalUnion(reusedSink.getCluster(), group.inputTraitSet, allSinkInputs, true, reusedSink.getRowType()) : new BatchPhysicalUnion(reusedSink.getCluster(), group.inputTraitSet, allSinkInputs, true, reusedSink.getRowType());
            reusedSink.replaceInput(0, unionForReusedSinks);
            reusedSinkNodes.add(reusedSink);
        });
        return reusedSinkNodes;
    }

    private List<ReusableSinkGroup> groupReusableSink(List<Sink> allSinkNodes) {
        ArrayList<ReusableSinkGroup> reusableSinkGroups = new ArrayList<ReusableSinkGroup>();
        for (Sink currentSinkNode : allSinkNodes) {
            Optional<ReusableSinkGroup> targetGroup = reusableSinkGroups.stream().filter(reusableSinkGroup -> reusableSinkGroup.canBeReused(currentSinkNode)).findFirst();
            if (targetGroup.isPresent()) {
                targetGroup.get().originalSinks.add(currentSinkNode);
                continue;
            }
            reusableSinkGroups.add(new ReusableSinkGroup(currentSinkNode));
        }
        return reusableSinkGroups;
    }

    private String getDigest(Sink sink) {
        ArrayList<Object> digest = new ArrayList<Object>();
        digest.add(sink.contextResolvedTable().getIdentifier().asSummaryString());
        int[][] targetColumns = sink.targetColumns();
        if (targetColumns != null && targetColumns.length > 0) {
            digest.add("targetColumns=[" + Arrays.stream(targetColumns).map(Arrays::toString).collect(Collectors.joining(",")) + "]");
        }
        String fieldTypes = sink.getRowType().getFieldList().stream().map(f -> f.getType().toString()).collect(Collectors.joining(", "));
        digest.add("fieldTypes=[" + fieldTypes + "]");
        if (!sink.hints().isEmpty()) {
            digest.add("hints=" + RelExplainUtil.hintsToString(sink.hints()));
        }
        if (this.isStreamingMode) {
            digest.add("upsertMaterialize=" + ((StreamPhysicalSink)sink).upsertMaterialize());
        }
        return ((Object)digest).toString();
    }

    private class ReusableSinkGroup {
        private final List<Sink> originalSinks = new ArrayList<Sink>();
        private final SinkAbilitySpec[] sinkAbilitySpecs;
        private final RelTraitSet inputTraitSet;
        private final String digest;

        ReusableSinkGroup(Sink sink) {
            this.originalSinks.add(sink);
            this.inputTraitSet = sink.getInput().getTraitSet();
            this.digest = SinkReuser.this.getDigest(sink);
            this.sinkAbilitySpecs = SinkReuser.this.isStreamingMode ? ((StreamPhysicalSink)sink).abilitySpecs() : ((BatchPhysicalSink)sink).abilitySpecs();
        }

        public boolean canBeReused(Sink sinkNode) {
            String currentSinkDigest = SinkReuser.this.getDigest(sinkNode);
            Object[] currentSinkSpecs = SinkReuser.this.isStreamingMode ? ((StreamPhysicalSink)sinkNode).abilitySpecs() : ((BatchPhysicalSink)sinkNode).abilitySpecs();
            RelTraitSet currentInputTraitSet = sinkNode.getInput().getTraitSet();
            return this.digest.equals(currentSinkDigest) && Arrays.equals(this.sinkAbilitySpecs, currentSinkSpecs) && this.inputTraitSet.equals(currentInputTraitSet);
        }
    }
}

